/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.mapped;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Function;
import org.jhotdraw8.collection.mapped.MappedSpliterator;
import org.jhotdraw8.icollection.facade.ReadOnlySequencedCollectionFacade;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySequencedCollection;

public final class MappedReadOnlyList<E, F>
extends AbstractReadOnlyList<E> {
    private final ReadOnlyList<F> backingList;
    private final Function<F, E> mapf;

    public MappedReadOnlyList(ReadOnlyList<F> backingList, Function<F, E> mapf) {
        this.backingList = backingList;
        this.mapf = mapf;
    }

    public boolean contains(Object o) {
        for (Object f : this.backingList) {
            if (!this.mapf.apply(f).equals(o)) continue;
            return true;
        }
        return false;
    }

    public E get(int index) {
        return this.mapf.apply(this.backingList.get(index));
    }

    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<F> i;
            {
                this.i = MappedReadOnlyList.this.backingList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public E next() {
                return MappedReadOnlyList.this.mapf.apply(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    Iterator<E> reverseIterator() {
        return new Iterator<E>(){
            private int i;
            {
                this.i = MappedReadOnlyList.this.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MappedReadOnlyList.this.mapf.apply(MappedReadOnlyList.this.backingList.get(this.i--));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ReadOnlySequencedCollection<E> readOnlyReversed() {
        return new ReadOnlySequencedCollectionFacade(this::reverseIterator, this::iterator, this::size, this::contains, () -> ((MappedReadOnlyList)this).getLast(), () -> ((MappedReadOnlyList)this).getFirst(), 16464);
    }

    public Spliterator<E> spliterator() {
        return new MappedSpliterator<E, F>(this.backingList.spliterator(), this.mapf);
    }

    public int size() {
        return this.backingList.size();
    }

    public ReadOnlyList<E> readOnlySubList(int fromIndex, int toIndex) {
        return new MappedReadOnlyList<E, F>(this.backingList.readOnlySubList(fromIndex, toIndex), this.mapf);
    }
}

