/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.mapped;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class MappedSpliterator<E, F>
implements Spliterator<E> {
    private final Spliterator<? extends F> s;
    private final Function<F, E> mappingFunction;
    private final int characteristics;

    public MappedSpliterator(Spliterator<? extends F> s, Function<F, E> mappingFunction, int characteristics) {
        this.s = s;
        this.mappingFunction = mappingFunction;
        this.characteristics = characteristics;
    }

    public MappedSpliterator(Spliterator<? extends F> s, Function<F, E> mappingFunction) {
        this(s, mappingFunction, s.characteristics());
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        return this.s.tryAdvance((? super T k) -> action.accept((E)this.mappingFunction.apply(k)));
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        Spliterator<? extends F> split = this.s.trySplit();
        return split == null ? null : new MappedSpliterator<E, F>(split, this.mappingFunction, this.characteristics);
    }

    @Override
    public long estimateSize() {
        return this.s.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

