/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.jhotdraw8.collection.primitive.ByteArraySpliterator;
import org.jhotdraw8.collection.primitive.ByteList;
import org.jhotdraw8.collection.primitive.PrimitiveIteratorOfByte;
import org.jhotdraw8.collection.primitive.SpliteratorOfByte;
import org.jhotdraw8.collection.util.ListHelper;
import org.jhotdraw8.icollection.facade.ListFacade;
import org.jspecify.annotations.Nullable;

public class ByteArrayList
extends AbstractList<Byte>
implements ByteList {
    private static final byte[] EMPTY = new byte[0];
    private byte[] items;
    private int size;

    public ByteArrayList() {
        this.items = EMPTY;
    }

    public ByteArrayList(int initialCapacity) {
        this.items = new byte[initialCapacity];
    }

    public ByteArrayList(Collection<Byte> collection) {
        this.size = collection.size();
        this.items = new byte[this.size];
        int count = 0;
        for (Byte value : collection) {
            this.items[count++] = value;
        }
    }

    private ByteArrayList(byte[] items) {
        this.items = items;
        this.size = items.length;
    }

    public static ByteArrayList of(byte ... items) {
        return new ByteArrayList(items);
    }

    @Override
    public void addAsByte(byte newItem) {
        this.grow(this.size + 1);
        this.items[this.size++] = newItem;
    }

    @Override
    public void addAsByte(int index, byte newItem) {
        Objects.checkIndex(index, this.size + 1);
        this.grow(this.size + 1);
        this.items[index] = newItem;
        ++this.size;
    }

    public void addAllAsByte(ByteArrayList that) {
        if (that.isEmpty()) {
            return;
        }
        this.grow(this.size + that.size);
        System.arraycopy(that.items, 0, this.items, this.size, that.size);
        this.size += that.size;
    }

    public <T extends Collection<Byte>> T addAllInto(T out) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            out.add(this.items[i]);
        }
        return out;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void copyInto(byte[] a, int offset) {
        System.arraycopy(this.items, 0, a, offset, this.size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayList other = (ByteArrayList)obj;
        if (other.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (other.items[i] == this.items[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte getAsByte(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public Byte get(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public byte getLastAsByte() {
        return this.getAsByte(this.size - 1);
    }

    @Override
    public byte getFirstAsByte() {
        return this.getAsByte(0);
    }

    public void setSize(int newSize) {
        this.grow(newSize);
        if (newSize > this.size) {
            Arrays.fill(this.items, this.size, newSize, (byte)0);
        }
        this.size = newSize;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.items[i];
        }
        return result;
    }

    private void grow(int capacity) {
        if (this.items.length < capacity) {
            this.items = ListHelper.grow(Math.max(1, this.items.length * 2), 1, this.items);
        }
    }

    @Override
    public int indexOfAsByte(byte item) {
        return this.indexOfAsByte(item, 0);
    }

    public int indexOfAsByte(byte item, int start) {
        for (int i = start; i < this.size; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAsByte(byte item) {
        return this.lastIndexOfAsByte(item, this.size - 1);
    }

    public int lastIndexOfAsByte(byte item, int start) {
        for (int i = start; i >= 0; --i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Byte) {
            Byte e = (Byte)o;
            return this.indexOfAsByte(e) != -1;
        }
        return false;
    }

    @Override
    public byte removeAtAsByte(int index) {
        Objects.checkIndex(index, this.size);
        byte removedItem = this.items[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, numMoved);
        }
        --this.size;
        return removedItem;
    }

    @Override
    public byte removeLastAsByte() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return this.removeAtAsByte(this.size - 1);
    }

    public byte setAsByte(int index, byte newItem) {
        Objects.checkIndex(index, this.size);
        byte removedItem = this.items[index];
        this.items[index] = newItem;
        return removedItem;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        this.items = ListHelper.trimToSize(this.size, 1, this.items);
    }

    public PrimitiveIteratorOfByte iterator() {
        return new PrimitiveIteratorOfByte(){
            private int index = 0;
            private final int size;
            private final byte[] items;
            {
                this.size = ByteArrayList.this.size;
                this.items = ByteArrayList.this.items;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.items[this.index++];
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }
        };
    }

    public SpliteratorOfByte spliterator() {
        return new ByteArraySpliterator(this.items, 0, this.size, 1040);
    }

    public IntStream byteStream() {
        return this.size == 0 ? IntStream.empty() : Arrays.stream(this.toIntArray(), 0, this.size);
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    public int[] toIntArray() {
        int[] result = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            result[i] = this.items[i];
        }
        return result;
    }

    @Override
    public boolean add(Byte e) {
        this.addAsByte(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Byte e;
        int index;
        if (o instanceof Byte && (index = this.indexOfAsByte(e = (Byte)o)) != -1) {
            this.removeAtAsByte(index);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.items[i]);
        }
        return b.append(']').toString();
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public boolean removeIfAsByte(IntPredicate filter) {
        boolean hasRemoved = false;
        Objects.requireNonNull(filter, "filter");
        for (int i = this.size - 1; i >= 0; --i) {
            if (!filter.test(this.getAsByte(i))) continue;
            this.removeAtAsByte(i);
            hasRemoved = true;
        }
        return hasRemoved;
    }

    @Override
    public void sort(@Nullable Comparator<? super Byte> c) {
        if (this.size > 1) {
            if (c == null) {
                Arrays.sort(this.items, 0, this.size);
            } else {
                int i;
                Byte[] objects = new Byte[this.size];
                for (i = 0; i < this.size; ++i) {
                    objects[i] = this.items[i];
                }
                Arrays.sort(objects, 0, this.size, c);
                for (i = 0; i < this.size; ++i) {
                    this.items[i] = objects[i];
                }
            }
        }
    }

    @Override
    public List<Byte> reversed() {
        return new ListFacade(this::size, i -> this.get(this.size() - i));
    }

    public byte[] getArray() {
        return this.items;
    }

    @Override
    public void addFirst(Byte e) {
        ByteList.super.addFirst(e);
    }

    @Override
    public void addLast(Byte e) {
        ByteList.super.addLast(e);
    }

    @Override
    public Byte getFirst() {
        return ByteList.super.getFirst();
    }

    @Override
    public Byte getLast() {
        return ByteList.super.getLast();
    }

    @Override
    public Byte removeFirst() {
        return ByteList.super.removeFirst();
    }

    @Override
    public Byte removeLast() {
        return ByteList.super.removeLast();
    }
}

