/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoublePredicate;
import java.util.stream.DoubleStream;
import org.jhotdraw8.collection.primitive.DoubleList;
import org.jhotdraw8.collection.util.ListHelper;
import org.jhotdraw8.icollection.facade.ListFacade;
import org.jspecify.annotations.Nullable;

public class DoubleArrayList
extends AbstractList<Double>
implements DoubleList {
    private static final double[] EMPTY = new double[0];
    private double[] items;
    private int size;

    public DoubleArrayList() {
        this.items = EMPTY;
    }

    public DoubleArrayList(int initialCapacity) {
        this.items = new double[initialCapacity];
    }

    public DoubleArrayList(Collection<Double> collection) {
        this.size = collection.size();
        this.items = new double[this.size];
        int count = 0;
        for (Double value : collection) {
            this.items[count++] = value;
        }
    }

    private DoubleArrayList(double[] items) {
        this.items = items;
        this.size = items.length;
    }

    public static DoubleArrayList of(double ... items) {
        return new DoubleArrayList(items);
    }

    @Override
    public void addAsDouble(double newItem) {
        this.grow(this.size + 1);
        this.items[this.size++] = newItem;
    }

    @Override
    public void addAsDouble(int index, double newItem) {
        Objects.checkIndex(index, this.size + 1);
        this.grow(this.size + 1);
        this.items[index] = newItem;
        ++this.size;
    }

    public void addAllAsDouble(DoubleArrayList that) {
        if (that.isEmpty()) {
            return;
        }
        this.grow(this.size + that.size);
        System.arraycopy(that.items, 0, this.items, this.size, that.size);
        this.size += that.size;
    }

    public <T extends Collection<Double>> T addAllInto(T out) {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            out.add(this.items[i]);
        }
        return out;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    public void copyInto(double[] a, int offset) {
        System.arraycopy(this.items, 0, a, offset, this.size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleArrayList other = (DoubleArrayList)obj;
        if (other.size != this.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (other.items[i] == this.items[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getAsDouble(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public Double get(int index) {
        Objects.checkIndex(index, this.size);
        return this.items[index];
    }

    @Override
    public double getLastAsDouble() {
        return this.getAsDouble(this.size - 1);
    }

    @Override
    public double getFirstAsDouble() {
        return this.getAsDouble(0);
    }

    public void setSize(int newSize) {
        this.grow(newSize);
        if (newSize > this.size) {
            Arrays.fill(this.items, this.size, newSize, 0.0);
        }
        this.size = newSize;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            long bits = Double.doubleToLongBits(this.items[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    private void grow(int capacity) {
        if (this.items.length < capacity) {
            this.items = ListHelper.grow(Math.max(1, this.items.length * 2), 1, this.items);
        }
    }

    @Override
    public int indexOfAsDouble(double item) {
        return this.indexOfAsDouble(item, 0);
    }

    public int indexOfAsDouble(double item, int start) {
        for (int i = start; i < this.size; ++i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOfAsDouble(double item) {
        return this.lastIndexOfAsDouble(item, this.size - 1);
    }

    public int lastIndexOfAsDouble(double item, int start) {
        for (int i = start; i >= 0; --i) {
            if (this.items[i] != item) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Double) {
            Double e = (Double)o;
            return this.indexOfAsDouble(e) != -1;
        }
        return false;
    }

    @Override
    public double removeAtAsDouble(int index) {
        Objects.checkIndex(index, this.size);
        double removedItem = this.items[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.items, index + 1, this.items, index, numMoved);
        }
        --this.size;
        return removedItem;
    }

    @Override
    public double removeLastAsDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("List is empty.");
        }
        return this.removeAtAsDouble(this.size - 1);
    }

    public double setAsDouble(int index, double newItem) {
        Objects.checkIndex(index, this.size);
        double removedItem = this.items[index];
        this.items[index] = newItem;
        return removedItem;
    }

    @Override
    public Double set(int index, Double newItem) {
        Objects.checkIndex(index, this.size);
        double removedItem = this.items[index];
        this.items[index] = newItem;
        return removedItem;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void trimToSize() {
        this.items = ListHelper.trimToSize(this.size, 1, this.items);
    }

    public PrimitiveIterator.OfDouble iterator() {
        return new PrimitiveIterator.OfDouble(){
            private int index = 0;
            private final int size;
            private final double[] items;
            {
                this.size = DoubleArrayList.this.size;
                this.items = DoubleArrayList.this.items;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.items[this.index++];
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }
        };
    }

    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.items, 0, this.size, 1040);
    }

    public DoubleStream doubleStream() {
        return this.size == 0 ? DoubleStream.empty() : Arrays.stream(this.items, 0, this.size);
    }

    public double[] toDoubleArray() {
        double[] result = new double[this.size];
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    @Override
    public boolean add(Double e) {
        this.addAsDouble(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Double e;
        int index;
        if (o instanceof Double && (index = this.indexOfAsDouble(e = (Double)o)) != -1) {
            this.removeAtAsDouble(index);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.items[i]);
        }
        return b.append(']').toString();
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public boolean removeIfAsDouble(DoublePredicate filter) {
        boolean hasRemoved = false;
        Objects.requireNonNull(filter, "filter");
        for (int i = this.size - 1; i >= 0; --i) {
            if (!filter.test(this.getAsDouble(i))) continue;
            this.removeAtAsDouble(i);
            hasRemoved = true;
        }
        return hasRemoved;
    }

    @Override
    public void sort(@Nullable Comparator<? super Double> c) {
        if (this.size > 1) {
            if (c == null) {
                Arrays.sort(this.items, 0, this.size);
            } else {
                int i;
                Double[] objects = new Double[this.size];
                for (i = 0; i < this.size; ++i) {
                    objects[i] = this.items[i];
                }
                Arrays.sort(objects, 0, this.size, c);
                for (i = 0; i < this.size; ++i) {
                    this.items[i] = objects[i];
                }
            }
        }
    }

    @Override
    public List<Double> reversed() {
        return new ListFacade(this::size, i -> this.get(this.size() - i));
    }

    public double[] getArray() {
        return this.items;
    }

    @Override
    public void addFirst(Double e) {
        DoubleList.super.addFirst(e);
    }

    @Override
    public void addLast(Double e) {
        DoubleList.super.addLast(e);
    }

    @Override
    public Double getFirst() {
        return DoubleList.super.getFirst();
    }

    @Override
    public Double getLast() {
        return DoubleList.super.getLast();
    }

    @Override
    public Double removeFirst() {
        return DoubleList.super.removeFirst();
    }

    @Override
    public Double removeLast() {
        return DoubleList.super.removeLast();
    }
}

