/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.jhotdraw8.collection.primitive.IntDeque;

public class IntArrayDeque
extends AbstractCollection<Integer>
implements IntDeque {
    private int[] elements;
    private int head;
    private int tail;

    public IntArrayDeque() {
        this(8);
    }

    public IntArrayDeque(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative. capacity=" + capacity + ".");
        }
        this.elements = new int[Math.max(Integer.highestOneBit(capacity + capacity - 1), 0)];
    }

    @Override
    public void addFirstAsInt(int e) {
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addFirstAsIntBranchless(int e, boolean reallyAdd) {
        int index = this.head - 1 & this.elements.length - 1;
        this.elements[index] = e;
        if (reallyAdd) {
            this.head = index;
            if (this.head == this.tail) {
                this.doubleCapacity();
            }
        }
    }

    @Override
    public void addLastAllAsInt(int[] array) {
        this.addLastAllAsInt(array, 0, array.length);
    }

    @Override
    public void addLastAllAsInt(int[] array, int offset, int length) {
        this.grow(length + this.size());
        int firstPart = this.elements.length - this.tail;
        if (this.tail >= this.head && firstPart >= length || this.head - this.tail > length) {
            System.arraycopy(array, offset, this.elements, this.tail, length);
            this.tail = this.tail + length & this.elements.length - 1;
            return;
        }
        System.arraycopy(array, offset, this.elements, this.tail, firstPart);
        int secondPart = length - firstPart;
        System.arraycopy(array, offset + firstPart, this.elements, 0, secondPart);
        this.tail = secondPart;
    }

    private void grow(int capacity) {
        if (this.elements.length > capacity) {
            return;
        }
        int newLength = Integer.highestOneBit(capacity + capacity - 1);
        int[] a = new int[newLength];
        int size = this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, a, 0, size);
        } else {
            int r = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, a, 0, r);
            System.arraycopy(this.elements, 0, a, r, this.head);
        }
        this.elements = a;
        this.head = 0;
        this.tail = size;
    }

    @Override
    public void addLastAsInt(int e) {
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public void addLastAsIntBranchless(int e, boolean reallyAdd) {
        this.elements[this.tail] = e;
        if (reallyAdd) {
            this.tail = this.tail + 1 & this.elements.length - 1;
            if (this.tail == this.head) {
                this.doubleCapacity();
            }
        }
    }

    @Override
    public void clear() {
        this.tail = 0;
        this.head = 0;
    }

    public PrimitiveIterator.OfInt descendingIterator() {
        return new ReverseDeqIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntArrayDeque)) {
            return false;
        }
        IntArrayDeque that = (IntArrayDeque)o;
        if (this.size() != that.size()) {
            return false;
        }
        int thisMask = this.elements.length - 1;
        int thatMask = that.elements.length - 1;
        int i = this.head;
        int j = that.head;
        while (i != this.tail) {
            if (this.elements[i] != that.elements[j]) {
                return false;
            }
            i = i + 1 & thisMask;
            j = j + 1 & thatMask;
        }
        return true;
    }

    public int firstIndexOfAsInt(int o) {
        if (this.tail < this.head) {
            int i;
            for (i = this.head; i < this.elements.length; ++i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
            for (i = 0; i < this.tail; ++i) {
                if (o != this.elements[i]) continue;
                return i + this.elements.length - this.head;
            }
        } else {
            for (int i = this.head; i < this.tail; ++i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
        }
        return -1;
    }

    @Override
    public int getFirstAsInt() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.elements[this.head];
    }

    public int getAsInt(int index) {
        Objects.checkIndex(index, this.size());
        return this.head + index < this.elements.length ? this.elements[this.head + index] : this.elements[this.head + index - this.elements.length];
    }

    @Override
    public int getLastAsInt() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        return this.elements[this.tail == 0 ? this.elements.length - 1 : this.tail - 1];
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int[] a = new int[n << 1];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            hash = hash * 31 + this.elements[i];
            i = i + 1 & mask;
        }
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Deque<Integer> reversed() {
        throw new UnsupportedOperationException();
    }

    public PrimitiveIterator.OfInt iterator() {
        return new DeqIterator();
    }

    public int lastIndexOfAsInt(int o) {
        if (this.tail < this.head) {
            int i;
            for (i = this.elements.length - 1; i >= this.head; --i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
            for (i = this.tail - 1; i >= 0; --i) {
                if (o != this.elements[i]) continue;
                return i + this.elements.length - this.head;
            }
        } else {
            for (int i = this.tail - 1; i >= this.head; --i) {
                if (o != this.elements[i]) continue;
                return i - this.head;
            }
        }
        return -1;
    }

    public void removeAt(int i) {
        int size = this.size();
        Objects.checkIndex(i, size);
        if (this.tail < this.head) {
            if (this.head + i < this.elements.length) {
                if (i > 0) {
                    System.arraycopy(this.elements, this.head, this.elements, this.head + 1, i - 1);
                }
                this.elements[this.head] = 0;
                this.head = this.head == this.elements.length ? 0 : this.head + 1;
            } else {
                if (i < size - 1) {
                    System.arraycopy(this.elements, i - this.elements.length + this.head + 1, this.elements, i - this.elements.length + this.head, size - i);
                }
                this.elements[this.tail] = 0;
                this.tail = this.tail == 0 ? this.elements.length : this.tail - 1;
            }
        } else {
            if (i < size - 1) {
                System.arraycopy(this.elements, this.head + i + 1, this.elements, this.head + i, size - i);
            }
            this.elements[this.head + i] = 0;
            --this.tail;
        }
    }

    @Override
    public int removeFirstAsInt() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        int result = this.elements[this.head];
        this.elements[this.head] = 0;
        this.head = this.head == this.elements.length - 1 ? 0 : this.head + 1;
        return result;
    }

    @Override
    public boolean removeFirstOccurrenceAsInt(int o) {
        int index = this.firstIndexOfAsInt(o);
        if (index != -1) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrenceAsInt(int o) {
        int index = this.lastIndexOfAsInt(o);
        if (index != -1) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    @Override
    public int removeLastAsInt() {
        if (this.head == this.tail) {
            throw new NoSuchElementException();
        }
        this.tail = this.tail == 0 ? this.elements.length - 1 : this.tail - 1;
        int result = this.elements[this.tail];
        this.elements[this.tail] = 0;
        return result;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.firstIndexOfAsInt((Integer)o) != -1;
        }
        return false;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public String toString() {
        PrimitiveIterator.OfInt it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Integer e = (Integer)it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private class ReverseDeqIterator
    implements PrimitiveIterator.OfInt {
        private final int fence;
        private int cursor;

        private ReverseDeqIterator() {
            this.fence = IntArrayDeque.this.head;
            this.cursor = IntArrayDeque.this.tail;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public int nextInt() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            int result = IntArrayDeque.this.elements[this.cursor];
            if (IntArrayDeque.this.tail != this.fence) {
                throw new ConcurrentModificationException();
            }
            this.cursor = this.cursor - 1 & IntArrayDeque.this.elements.length - 1;
            return result;
        }
    }

    private class DeqIterator
    implements PrimitiveIterator.OfInt {
        private final int fence;
        private int cursor;

        private DeqIterator() {
            this.fence = IntArrayDeque.this.tail;
            this.cursor = IntArrayDeque.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        @Override
        public int nextInt() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            int result = IntArrayDeque.this.elements[this.cursor];
            if (IntArrayDeque.this.tail != this.fence) {
                throw new ConcurrentModificationException();
            }
            this.cursor = this.cursor + 1 & IntArrayDeque.this.elements.length - 1;
            return result;
        }
    }
}

