/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jhotdraw8.icollection.readonly.AbstractReadOnlySet;
import org.jspecify.annotations.Nullable;

public class IntRangeSet
extends AbstractReadOnlySet<Integer> {
    private final int from;
    private final int to;

    public IntRangeSet(int from, int to) {
        Objects.checkIndex(from, to);
        this.from = from;
        this.to = to;
    }

    public Iterator<Integer> iterator() {
        return IntStream.range(this.from, this.to).iterator();
    }

    public int size() {
        return this.to - this.from;
    }

    public boolean contains(@Nullable Object o) {
        if (o instanceof Integer) {
            int e = (Integer)o;
            return this.from <= e && e < this.to;
        }
        return false;
    }
}

