/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import org.jhotdraw8.collection.primitive.LongQueue;

public class LongArrayHeap
extends AbstractCollection<Long>
implements LongQueue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private long[] array;
    private int size;

    public LongArrayHeap() {
        this(16);
    }

    public LongArrayHeap(int capacity) {
        Objects.checkIndex(capacity + 1, 0x7FFFFFF6);
        this.array = new long[capacity + 1];
        this.array[0] = Long.MIN_VALUE;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return Spliterators.iterator(Arrays.spliterator(this.array, 1, this.size + 1));
    }

    @Override
    public boolean containsAsLong(long e) {
        for (int i = this.size; i > 0; --i) {
            long l = this.array[i];
            if (l != e) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public long elementAsLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.array[1];
    }

    @Override
    public boolean offerAsLong(long key) {
        return this.addAsLong(key);
    }

    @Override
    public boolean addAsLong(long key) {
        if (this.size == this.array.length - 1) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
        ++this.size;
        int hole = this.size;
        int pred = hole >>> 1;
        long predElem = this.array[pred];
        while (predElem > key) {
            this.array[hole] = predElem;
            hole = pred;
            predElem = this.array[pred >>>= 1];
        }
        this.array[hole] = key;
        return true;
    }

    @Override
    public long removeAsLong() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        long result = this.array[1];
        int hole = 1;
        int sz = this.size;
        for (int succ = 2; succ < sz; succ <<= 1) {
            long key1 = this.array[succ];
            long key2 = this.array[succ + 1];
            this.array[hole] = key1 > key2 ? key2 : key1;
            hole = ++succ;
        }
        long bubble = this.array[sz];
        int pred = hole >>> 1;
        while (this.array[pred] > bubble) {
            this.array[hole] = this.array[pred];
            hole = pred;
            pred >>>= 1;
        }
        this.array[hole] = bubble;
        this.array[this.size] = Long.MAX_VALUE;
        this.size = sz - 1;
        return result;
    }

    @Override
    public boolean removeAsLong(long e) {
        int i;
        long[] buf = new long[this.size];
        boolean removed = false;
        for (i = 0; i < this.size; ++i) {
            long l = this.removeAsLong();
            if (l >= e) {
                removed = l == e;
                break;
            }
            buf[i] = l;
        }
        for (int j = 0; j < i; ++j) {
            this.addAsLong(buf[j]);
        }
        return removed;
    }

    public LongArrayHeap clone() {
        try {
            LongArrayHeap that = (LongArrayHeap)super.clone();
            that.array = (long[])this.array.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

