/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.primitive;

import java.util.Collection;
import java.util.PrimitiveIterator;
import java.util.Queue;
import java.util.Spliterator;
import org.jhotdraw8.collection.primitive.LongArrayList;
import org.jspecify.annotations.Nullable;

public interface LongQueue
extends Queue<Long> {
    public boolean addAsLong(long var1);

    @Override
    default public boolean add(Long e) {
        return this.addAsLong(e);
    }

    @Override
    default public boolean addAll(Collection<? extends Long> c) {
        boolean added = false;
        for (Long l : c) {
            added |= this.add(l);
        }
        return added;
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object e : c) {
            removed |= this.remove(e);
        }
        return removed;
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        LongArrayList tmp = new LongArrayList(this.size());
        ((Spliterator.OfLong)this.spliterator()).forEachRemaining(tmp::addAsLong);
        this.clear();
        boolean removed = false;
        PrimitiveIterator.OfLong i = tmp.iterator();
        while (i.hasNext()) {
            long current = i.nextLong();
            if (c.contains(current)) {
                this.addAsLong(current);
                continue;
            }
            removed = true;
        }
        return removed;
    }

    public boolean offerAsLong(long var1);

    @Override
    default public boolean offer(Long e) {
        return this.offerAsLong(e);
    }

    public long removeAsLong();

    @Override
    default public Long remove() {
        return this.removeAsLong();
    }

    public boolean removeAsLong(long var1);

    @Override
    default public boolean remove(Object e) {
        return e instanceof Long && this.removeAsLong((Long)e);
    }

    @Override
    default public @Nullable Long poll() {
        return this.isEmpty() ? null : Long.valueOf(this.removeAsLong());
    }

    @Override
    default public Long element() {
        return this.elementAsLong();
    }

    public long elementAsLong();

    @Override
    default public @Nullable Long peek() {
        return this.isEmpty() ? null : Long.valueOf(this.elementAsLong());
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsAsLong(long var1);

    @Override
    default public boolean contains(Object e) {
        return e instanceof Long && this.containsAsLong((Long)e);
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }
}

