/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.spliterator;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.jspecify.annotations.Nullable;

public class FailFastSpliterator<E>
extends Spliterators.AbstractSpliterator<E> {
    private final Spliterator<? extends E> s;
    private final int expectedModCount;
    private final IntSupplier modCountSupplier;

    public FailFastSpliterator(Spliterator<? extends E> s, IntSupplier modCountSupplier) {
        super(s.estimateSize(), s.characteristics());
        this.s = s;
        this.modCountSupplier = modCountSupplier;
        this.expectedModCount = modCountSupplier.getAsInt();
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        this.ensureUnmodified();
        return this.s.tryAdvance(action);
    }

    protected void ensureUnmodified() {
        if (this.expectedModCount != this.modCountSupplier.getAsInt()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public @Nullable Spliterator<E> trySplit() {
        Spliterator<? extends E> split = this.s.trySplit();
        return split == null ? null : new FailFastSpliterator<E>(split, this.modCountSupplier);
    }

    @Override
    public long estimateSize() {
        return this.s.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.s.characteristics() & 0xFFFFFBFF;
    }
}

