/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.spliterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public class IteratorFacade<E>
implements Iterator<E>,
Consumer<E> {
    private final Spliterator<E> e;
    private final @Nullable Consumer<E> removeFunction;
    private boolean valueReady;
    private boolean canRemove;
    private E current;

    public IteratorFacade(Spliterator<E> e, @Nullable Consumer<E> removeFunction) {
        this.e = e;
        this.removeFunction = removeFunction;
    }

    @Override
    public boolean hasNext() {
        if (!this.valueReady) {
            this.valueReady = this.e.tryAdvance(this);
        }
        return this.valueReady;
    }

    @Override
    public E next() {
        if (!this.valueReady && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.valueReady = false;
        this.canRemove = true;
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException();
        }
        if (this.removeFunction != null) {
            this.removeFunction.accept(this.current);
            this.canRemove = false;
        } else {
            Iterator.super.remove();
        }
    }

    @Override
    public void accept(E e) {
        this.current = e;
    }
}

