/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.collection.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ListHelper {
    private ListHelper() {
    }

    public static <T> T[] copyAddAll(T[] src, int index, T[] values) {
        T[] dst = ListHelper.copyComponentAdd(src, index, values.length);
        System.arraycopy(values, 0, dst, index, values.length);
        return dst;
    }

    public static <T> T[] copyComponentAdd(T[] src, int index, int numComponents) {
        if (index == src.length) {
            return Arrays.copyOf(src, src.length + numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length + numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index, dst, index + numComponents, src.length - index);
        return dst;
    }

    public static <T> T[] copyComponentRemove(T[] src, int index, int numComponents) {
        if (index == src.length - numComponents) {
            return Arrays.copyOf(src, src.length - numComponents);
        }
        Object[] dst = (Object[])Array.newInstance(src.getClass().getComponentType(), src.length - numComponents);
        System.arraycopy(src, 0, dst, 0, index);
        System.arraycopy(src, index + numComponents, dst, index, src.length - index - numComponents);
        return dst;
    }

    public static <T> T[] copySet(T[] src, int index, T value) {
        T[] dst = Arrays.copyOf(src, src.length);
        dst[index] = value;
        return dst;
    }

    public static Object[] grow(int targetCapacity, int itemSize, Object[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength, items.getClass());
    }

    public static double[] grow(int targetCapacity, int itemSize, double[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static byte[] grow(int targetCapacity, int itemSize, byte[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static short[] grow(int targetCapacity, int itemSize, short[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static int[] grow(int targetCapacity, int itemSize, int[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static long[] grow(int targetCapacity, int itemSize, long[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static char[] grow(int targetCapacity, int itemSize, char[] items) {
        if (targetCapacity * itemSize <= items.length) {
            return items;
        }
        int newLength = Integer.max(targetCapacity * itemSize, items.length * 2);
        return Arrays.copyOf(items, newLength);
    }

    public static Object[] trimToSize(int size, int itemSize, Object[] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static int[] trimToSize(int size, int itemSize, int[] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static long[] trimToSize(int size, int itemSize, long[] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static double[] trimToSize(int size, int itemSize, double[] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }

    public static byte[] trimToSize(int size, int itemSize, byte[] items) {
        int newLength = size * itemSize;
        if (items.length == newLength) {
            return items;
        }
        return Arrays.copyOf(items, newLength);
    }
}

