/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;

public class ClassSelector
extends SimpleSelector {
    private final @NonNull String clazz;

    public ClassSelector(@Nullable SourceLocator sourceLocator, @NonNull String clazz) {
        super(sourceLocator);
        this.clazz = clazz;
    }

    public @NonNull String toString() {
        return "Class:" + this.clazz;
    }

    @Override
    public <T> @Nullable T match(@NonNull SelectorModel<T> model, @Nullable T element) {
        return element != null && model.hasStyleClass(element, this.clazz) ? (T)element : null;
    }

    @Override
    public int getSpecificity() {
        return 10;
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(46));
        consumer.accept(new CssToken(-2, this.clazz));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSelector that = (ClassSelector)o;
        return this.clazz.equals(that.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.clazz);
    }
}

