/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.AbstractAttributeSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;

public class EqualsMatchSelector
extends AbstractAttributeSelector {
    private final @Nullable String namespacePattern;
    private final @NonNull String attributeName;
    private final @NonNull String attributeValue;

    public EqualsMatchSelector(@Nullable SourceLocator sourceLocator, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String attributeValue) {
        super(sourceLocator);
        this.namespacePattern = namespacePattern;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    @Override
    protected <T> @Nullable T match(@NonNull SelectorModel<T> model, @NonNull T element) {
        return (T)(model.attributeValueEquals(element, this.namespacePattern, this.attributeName, this.attributeValue) ? element : null);
    }

    public @NonNull String toString() {
        return "[" + this.attributeName + "=\"" + this.attributeValue + "\"]";
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(91));
        if (!"*".equals(this.namespacePattern)) {
            if (this.namespacePattern != null) {
                consumer.accept(new CssToken(-2, this.namespacePattern));
            }
            consumer.accept(new CssToken(124));
        }
        consumer.accept(new CssToken(-2, this.attributeName));
        consumer.accept(new CssToken(61));
        consumer.accept(new CssToken(-4, this.attributeValue));
        consumer.accept(new CssToken(93));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqualsMatchSelector that = (EqualsMatchSelector)o;
        return Objects.equals(this.namespacePattern, that.namespacePattern) && this.attributeName.equals(that.attributeName) && this.attributeValue.equals(that.attributeValue);
    }

    public int hashCode() {
        return Objects.hash(this.namespacePattern, this.attributeName, this.attributeValue);
    }
}

