/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.Combinator;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;

public class GeneralSiblingCombinator
extends Combinator {
    public GeneralSiblingCombinator(@Nullable SourceLocator sourceLocator, @NonNull SimpleSelector first, @NonNull Selector second) {
        super(sourceLocator, first, second);
    }

    @Override
    public @NonNull String toString() {
        return String.valueOf(this.first) + " ~ " + String.valueOf(this.second);
    }

    @Override
    public <T> @Nullable T match(@NonNull SelectorModel<T> model, T element) {
        T secondMatch = this.second.match(model, element);
        if (secondMatch != null) {
            T siblingElement = model.getPreviousSibling(element);
            while (siblingElement != null) {
                T firstMatch = this.first.match(model, siblingElement);
                if (firstMatch != null) {
                    return secondMatch;
                }
                siblingElement = model.getPreviousSibling(siblingElement);
            }
        }
        return null;
    }

    @Override
    public final int getSpecificity() {
        return this.first.getSpecificity() + this.second.getSpecificity();
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        this.first.produceTokens(consumer);
        consumer.accept(new CssToken(126));
        this.second.produceTokens(consumer);
    }

    @Override
    public @Nullable TypeSelector matchesOnlyOnASpecificType() {
        return this.second.matchesOnlyOnASpecificType();
    }
}

