/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;

public class IdSelector
extends SimpleSelector {
    private final @NonNull String id;

    public IdSelector(@Nullable SourceLocator sourceLocator, @NonNull String id) {
        super(sourceLocator);
        this.id = id;
    }

    public @NonNull String toString() {
        return "Id:" + this.id;
    }

    @Override
    public <T> @Nullable T match(@NonNull SelectorModel<T> model, @Nullable T element) {
        return element != null && model.hasId(element, this.id) ? (T)element : null;
    }

    @Override
    public int getSpecificity() {
        return 100;
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(-8, this.id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdSelector that = (IdSelector)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

