/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;

public class SelectorGroup
extends Selector {
    private final @NonNull ReadOnlyList<Selector> selectors;

    public SelectorGroup(@Nullable SourceLocator sourceLocator, @NonNull Selector selector) {
        super(sourceLocator);
        this.selectors = VectorList.of((Object[])new Selector[]{selector});
    }

    public SelectorGroup(@Nullable SourceLocator sourceLocator, @NonNull List<Selector> selectors) {
        super(sourceLocator);
        this.selectors = VectorList.copyOf(selectors);
    }

    public @NonNull String toString() {
        StringBuilder buf = new StringBuilder("( ");
        boolean first = true;
        for (Selector s : this.selectors) {
            if (first) {
                first = false;
            } else {
                buf.append(" || ");
            }
            buf.append(s);
        }
        buf.append(" )");
        return buf.toString();
    }

    @Override
    public int getSpecificity() {
        return this.selectors.stream().mapToInt(Selector::getSpecificity).sum();
    }

    @Override
    public <T> boolean matches(SelectorModel<T> model, T element) {
        return this.match(model, element) != null;
    }

    @Override
    protected <T> @Nullable T match(SelectorModel<T> model, T element) {
        for (Selector s : this.selectors) {
            T result = s.match(model, element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> @Nullable Selector matchSelector(@NonNull SelectorModel<T> model, @NonNull T element) {
        int maxSpecificity = 0;
        Selector found = null;
        for (Selector s : this.selectors) {
            T result = s.match(model, element);
            if (result == null) continue;
            int specificity = s.getSpecificity();
            if (found != null && specificity < maxSpecificity) continue;
            found = s;
            maxSpecificity = specificity;
        }
        return found;
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        boolean first = true;
        for (Selector s : this.selectors) {
            if (first) {
                first = false;
            } else {
                consumer.accept(new CssToken(44));
                consumer.accept(new CssToken(-16, "\n"));
            }
            s.produceTokens(consumer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorGroup that = (SelectorGroup)o;
        return this.selectors.equals(that.selectors);
    }

    public int hashCode() {
        return Objects.hash(this.selectors);
    }

    @Override
    public @Nullable TypeSelector matchesOnlyOnASpecificType() {
        TypeSelector typeSelector = null;
        int n = this.selectors.size();
        for (int i = 0; i < n; ++i) {
            if (!(i == 0 ? (typeSelector = ((Selector)this.selectors.get(i)).matchesOnlyOnASpecificType()) == null : !typeSelector.equals(((Selector)this.selectors.get(i)).matchesOnlyOnASpecificType()))) continue;
            return null;
        }
        return typeSelector;
    }
}

