/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.Declaration;
import org.jhotdraw8.css.ast.Rule;
import org.jhotdraw8.css.ast.SelectorGroup;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class StyleRule
extends Rule {
    private final @NonNull SelectorGroup selectorList;
    private final @NonNull ImmutableList<Declaration> declarations;

    public StyleRule(@Nullable SourceLocator sourceLocator, @NonNull SelectorGroup selectorGroup, @NonNull List<Declaration> declarations) {
        super(sourceLocator);
        this.selectorList = selectorGroup;
        this.declarations = VectorList.copyOf(declarations);
    }

    public @NonNull String toString() {
        StringBuilder buf = new StringBuilder("StyleRule: ");
        buf.append(this.selectorList);
        buf.append("{");
        for (Declaration r : this.declarations) {
            buf.append(r.toString());
            buf.append(';');
        }
        buf.append("}");
        return buf.toString();
    }

    public SelectorGroup getSelectorGroup() {
        return this.selectorList;
    }

    public @NonNull ImmutableList<Declaration> getDeclarations() {
        return this.declarations;
    }
}

