/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;

public class TypeSelector
extends SimpleSelector {
    public static final @NonNull String ANY_NAMESPACE = "*";
    public static final @Nullable String WITHOUT_NAMESPACE = null;
    private final @Nullable String namespacePattern;
    private final @NonNull String type;

    public TypeSelector(@Nullable SourceLocator sourceLocator, @Nullable String namespacePattern, @NonNull String type) {
        super(sourceLocator);
        this.namespacePattern = namespacePattern;
        this.type = type;
    }

    public @NonNull String toString() {
        return "Type:" + (String)(this.namespacePattern == null ? "" : this.namespacePattern + "|") + this.type;
    }

    @Override
    public <T> @Nullable T match(@NonNull SelectorModel<T> model, @Nullable T element) {
        return element != null && model.hasType(element, this.namespacePattern, this.type) ? (T)element : null;
    }

    @Override
    public int getSpecificity() {
        return 1;
    }

    @Override
    public void produceTokens(@NonNull Consumer<CssToken> consumer) {
        if (!ANY_NAMESPACE.equals(this.namespacePattern)) {
            if (this.namespacePattern != null) {
                consumer.accept(new CssToken(-2, this.namespacePattern));
            }
            consumer.accept(new CssToken(124));
        }
        consumer.accept(new CssToken(-2, this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSelector that = (TypeSelector)o;
        return Objects.equals(this.namespacePattern, that.namespacePattern) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.namespacePattern, this.type);
    }

    public @Nullable String getNamespacePattern() {
        return this.namespacePattern;
    }

    public @NonNull String getType() {
        return this.type;
    }

    @Override
    public @Nullable TypeSelector matchesOnlyOnASpecificType() {
        return this;
    }
}

