/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public interface CssConverter<T>
extends Converter<T> {
    public @Nullable T parse(@NonNull CssTokenizer var1, @Nullable IdResolver var2) throws ParseException, IOException;

    default public @NonNull T parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        T value = this.parse(tt, idResolver);
        if (value == null) {
            throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a non-null value.", tt.getStartPosition());
        }
        return value;
    }

    public <TT extends T> void produceTokens(@Nullable TT var1, @Nullable IdSupplier var2, @NonNull Consumer<CssToken> var3) throws IOException;

    default public <TT extends T> @NonNull List<CssToken> toTokens(@Nullable TT value, @Nullable IdSupplier idSupplier) throws IOException {
        ArrayList<CssToken> list = new ArrayList<CssToken>();
        this.produceTokens(value, idSupplier, list::add);
        return list;
    }

    default public <TT extends T> @NonNull String toString(@Nullable TT value) {
        return this.toString(value, null);
    }

    default public <TT extends T> @NonNull String toString(@Nullable TT value, @Nullable IdFactory idFactory) {
        StringBuilder buf = new StringBuilder();
        try {
            this.produceTokens(value, (IdSupplier)idFactory, buf::append);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buf.toString();
    }

    default public <TT extends T> void toString(@NonNull Appendable out, @Nullable IdSupplier idSupplier, TT value) throws IOException {
        Consumer<CssToken> consumer = token -> {
            try {
                out.append(token.fromToken());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        try {
            this.produceTokens(value, idSupplier, consumer);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    default public T fromString(@NonNull CharSequence buf, @Nullable IdResolver idResolver) throws ParseException {
        try {
            StreamCssTokenizer tt = new StreamCssTokenizer(buf, null);
            return this.parse(tt, idResolver);
        }
        catch (IOException e) {
            throw (ParseException)new ParseException("Could not parse the value because of an IOException.", 0).initCause(e);
        }
    }

    default public T fromString(@NonNull CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        try {
            int startPos = buf.position();
            StreamCssTokenizer tt = new StreamCssTokenizer(buf, null);
            T value = this.parse(tt, idResolver);
            buf.position(startPos + tt.getNextPosition());
            return value;
        }
        catch (IOException e) {
            throw (ParseException)new ParseException("Could not parse the value because of an IOException.", 0).initCause(e);
        }
    }

    public @Nullable String getHelpText();

    default public @NonNull ImmutableList<String> getExamples() {
        return VectorList.of();
    }

    public boolean isNullable();
}

