/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class IntegerCssConverter
extends AbstractCssConverter<Integer> {
    public IntegerCssConverter(boolean nullable) {
        super(nullable);
    }

    @Override
    public @NonNull Integer parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        switch (tt.next()) {
            case -9: {
                break;
            }
            default: {
                throw tt.createParseException("Could not convert " + String.valueOf(tt.getToken()) + " to an integer value.");
            }
        }
        return tt.currentNumberNonNull().intValue();
    }

    @Override
    public <TT extends Integer> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-9, value));
    }

    @Override
    public @Nullable String getHelpText() {
        return "Format of \u27e8Integer\u27e9: \u27e8integer\u27e9";
    }
}

