/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class LiteralEnumCssConverter<E extends Enum<E>>
implements CssConverter<E> {
    private final @NonNull Class<E> enumClass;
    private final @NonNull String name;
    private final boolean nullable;

    public LiteralEnumCssConverter(@NonNull Class<E> enumClass) {
        this(enumClass, false);
    }

    public LiteralEnumCssConverter(@NonNull Class<E> enumClass, boolean nullable) {
        this.enumClass = enumClass;
        this.name = enumClass.getName().substring(enumClass.getName().lastIndexOf(46) + 1);
        this.nullable = nullable;
    }

    @Override
    public @Nullable E parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -2) {
            throw new ParseException(this.name + ": identifier expected", tt.getStartPosition());
        }
        String identifier = tt.currentStringNonNull();
        if (this.nullable && "none".equals(identifier)) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, identifier);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(this.name + ": illegal identifier:" + identifier, tt.getStartPosition());
        }
    }

    @Override
    public @Nullable String getHelpText() {
        StringBuilder buf = new StringBuilder("Format of \u27e8");
        buf.append(this.name).append("\u27e9: ");
        boolean first = true;
        if (this.nullable) {
            buf.append("none");
            first = false;
        }
        for (Field f : this.enumClass.getDeclaredFields()) {
            if (!f.isEnumConstant()) continue;
            if (first) {
                first = false;
            } else {
                buf.append('\uff5c');
            }
            buf.append(f.getName());
        }
        return buf.toString();
    }

    @Override
    public <TT extends E> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> consumer) {
        if (value == null) {
            if (!this.nullable) {
                throw new IllegalArgumentException("Could not convert the enum value=null to a string.");
            }
            consumer.accept(new CssToken(-2, "none"));
        } else {
            consumer.accept(new CssToken(-2, ((Enum)value).name()));
        }
    }

    @Override
    public @NonNull String toString(@Nullable E value) {
        StringBuilder out = new StringBuilder();
        this.produceTokens(value, null, (CssToken token) -> out.append(token.fromToken()));
        return out.toString();
    }

    public @Nullable E getDefaultValue() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }
}

