/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class NumberCssConverter
extends AbstractCssConverter<Number> {
    private final @NonNull Class<? extends Number> clazz;

    public NumberCssConverter(boolean nullable) {
        this(Double.class, nullable);
    }

    public NumberCssConverter(@NonNull Class<? extends Number> clazz, boolean nullable) {
        super(nullable);
        this.clazz = clazz;
    }

    @Override
    public @NonNull Number parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        return switch (tt.next()) {
            case -9 -> tt.currentNumberNonNull();
            case -2 -> {
                double v1 = switch (tt.currentStringNonNull()) {
                    case "INF" -> Double.POSITIVE_INFINITY;
                    case "-INF" -> Double.NEGATIVE_INFINITY;
                    case "NaN" -> Double.NaN;
                    default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
                };
                double value = v1;
                yield value;
            }
            default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
        };
    }

    @Override
    public <TT extends Number> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-9, value));
    }

    @Override
    public @Nullable String getHelpText() {
        return "Format of \u27e8Number\u27e9: \u27e8number\u27e9";
    }
}

