/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.icollection.ChampVectorSet;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableSequencedSet;

public class SetCssConverter<T>
implements CssConverter<ImmutableSequencedSet<T>> {
    private final @Nullable Comparator<T> comparatorForSorting;
    private final @NonNull CssConverter<T> elementConverter;
    private final @NonNull ImmutableList<CssToken> delimiter;
    private final @NonNull ImmutableList<CssToken> prefix;
    private final @NonNull ImmutableList<CssToken> suffix;
    private final @NonNull Set<Integer> delimiterChars;

    public SetCssConverter(@NonNull CssConverter<T> elementConverter) {
        this(elementConverter, ", ");
    }

    public SetCssConverter(@NonNull CssConverter<T> elementConverter, @Nullable String delimiter) {
        this(elementConverter, delimiter, null, null);
    }

    public SetCssConverter(@NonNull CssConverter<T> elementConverter, @Nullable String delimiter, @Nullable String prefix, @Nullable String suffix) {
        this(elementConverter, SetCssConverter.parseDelim(delimiter == null ? " " : delimiter), SetCssConverter.parseDelim(prefix), SetCssConverter.parseDelim(suffix));
    }

    public SetCssConverter(@NonNull CssConverter<T> elementConverter, @Nullable String delimiter, @Nullable String prefix, @Nullable String suffix, @Nullable Comparator<T> comparatorForSorting) {
        this(elementConverter, SetCssConverter.parseDelim(delimiter), SetCssConverter.parseDelim(prefix), SetCssConverter.parseDelim(suffix), comparatorForSorting);
    }

    private static List<CssToken> parseDelim(@Nullable String delim) {
        try {
            return delim == null ? List.of() : new StreamCssTokenizer(delim, null).toTokenList();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public SetCssConverter(@NonNull CssConverter<T> elementConverter, @NonNull Iterable<CssToken> delimiter, @NonNull Iterable<CssToken> prefix, @NonNull Iterable<CssToken> suffix) {
        this(elementConverter, delimiter, prefix, suffix, null);
    }

    public SetCssConverter(@NonNull CssConverter<T> elementConverter, @NonNull Iterable<CssToken> delimiter, @NonNull Iterable<CssToken> prefix, @NonNull Iterable<CssToken> suffix, @Nullable Comparator<T> comparatorForSorting) {
        this.elementConverter = elementConverter;
        this.delimiter = VectorList.copyOf(delimiter);
        this.prefix = VectorList.copyOf(prefix);
        this.suffix = VectorList.copyOf(suffix);
        this.delimiterChars = new HashSet<Integer>();
        for (CssToken cssToken : delimiter) {
            if (cssToken.getType() < 0) continue;
            this.delimiterChars.add(cssToken.getType());
        }
        this.comparatorForSorting = comparatorForSorting;
    }

    @Override
    public ImmutableSequencedSet<T> parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() == -2 && "none".equals(tt.currentString())) {
            return ChampVectorSet.of();
        }
        tt.pushBack();
        ArrayList<T> list = new ArrayList<T>();
        block4: while (true) {
            int ttype;
            if (this.delimiterChars.contains(ttype = tt.nextNoSkip())) {
                continue;
            }
            switch (ttype) {
                case -16: {
                    continue block4;
                }
                case -1: 
                case 41: 
                case 59: 
                case 93: 
                case 125: {
                    tt.pushBack();
                    break block4;
                }
                default: {
                    tt.pushBack();
                    T elem = this.elementConverter.parse(tt, idResolver);
                    if (elem == null) continue block4;
                    list.add(elem);
                    continue block4;
                }
            }
            break;
        }
        tt.pushBack();
        if (this.comparatorForSorting != null) {
            list.sort(this.comparatorForSorting);
        }
        return ChampVectorSet.copyOf(list);
    }

    @Override
    public <TT extends ImmutableSequencedSet<T>> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) throws IOException {
        Object ordered;
        if (value == null || value.isEmpty()) {
            out.accept(new CssToken(-2, "none"));
            return;
        }
        for (CssToken t : this.prefix) {
            out.accept(t);
        }
        boolean first = true;
        if (this.comparatorForSorting != null) {
            ArrayList<T> ts = new ArrayList<T>(value.asCollection());
            ts.sort(this.comparatorForSorting);
            ordered = ts;
        } else {
            ordered = value;
        }
        for (Object elem : ordered) {
            if (elem == null) continue;
            if (first) {
                first = false;
            } else {
                for (CssToken t : this.delimiter) {
                    out.accept(t);
                }
            }
            this.elementConverter.produceTokens(elem, idSupplier, out);
        }
        for (CssToken t : this.suffix) {
            out.accept(t);
        }
    }

    public @Nullable ImmutableSequencedSet<T> getDefaultValue() {
        return ChampVectorSet.of();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    public boolean needsIdResolver() {
        return this.elementConverter.needsIdResolver();
    }

    @Override
    public @Nullable String getHelpText() {
        return "Format of \u27e8Set\u27e9: empty | \u27e8Item\u27e9, \u27e8Item\u27e9, ...\nWith \u27e8Item\u27e9:\n  " + this.elementConverter.getHelpText();
    }
}

