/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;

public final class SizeCssConverter
implements CssConverter<CssSize> {
    private final boolean nullable;

    public SizeCssConverter(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public @Nullable CssSize parse(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (this.nullable) {
            if (tt.next() == -2 && "none".equals(tt.currentString())) {
                return null;
            }
            tt.pushBack();
        }
        return SizeCssConverter.parseSizeOrPercentage(tt, "size");
    }

    public static CssSize parseSize(@NonNull CssTokenizer tt, String variable) throws ParseException, IOException {
        return switch (tt.next()) {
            case -9 -> CssSize.of(tt.currentNumberNonNull().doubleValue());
            case -11 -> CssSize.of(tt.currentNumberNonNull().doubleValue(), tt.currentString());
            case -2 -> {
                switch (tt.currentStringNonNull()) {
                    case "NaN": {
                        yield CssSize.of(Double.NaN);
                    }
                    case "INF": {
                        yield CssSize.of(Double.POSITIVE_INFINITY);
                    }
                    case "-INF": {
                        yield CssSize.of(Double.NEGATIVE_INFINITY);
                    }
                }
                throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
            }
            default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
        };
    }

    public static CssSize parseSizeOrPercentage(@NonNull CssTokenizer tt, String variable) throws ParseException, IOException {
        return switch (tt.next()) {
            case -9 -> CssSize.of(tt.currentNumberNonNull().doubleValue());
            case -11 -> CssSize.of(tt.currentNumberNonNull().doubleValue(), tt.currentString());
            case -10 -> CssSize.of(tt.currentNumberNonNull().doubleValue(), "%");
            case -2 -> {
                switch (tt.currentStringNonNull()) {
                    case "NaN": {
                        yield CssSize.of(Double.NaN);
                    }
                    case "INF": {
                        yield CssSize.of(Double.POSITIVE_INFINITY);
                    }
                    case "-INF": {
                        yield CssSize.of(Double.NEGATIVE_INFINITY);
                    }
                }
                throw new ParseException("Could not convert the " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
            }
            default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a double value.", tt.getStartPosition());
        };
    }

    @Override
    public <TT extends CssSize> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        if (value == null) {
            out.accept(new CssToken(-2, "none"));
        } else if ("".equals(value.getUnits())) {
            out.accept(new CssToken(-9, value.getValue(), ""));
        } else {
            switch (value.getUnits()) {
                case "%": {
                    out.accept(new CssToken(-10, value.getValue(), "%"));
                    break;
                }
                default: {
                    out.accept(new CssToken(-11, value.getValue(), value.getUnits()));
                }
            }
        }
    }

    public @Nullable CssSize getDefaultValue() {
        return this.nullable ? null : CssSize.ZERO;
    }

    @Override
    public @Nullable String getHelpText() {
        return "Format of \u27e8Size\u27e9: \u27e8size\u27e9 | \u27e8percentage\u27e9% | \u27e8size\u27e9\u27e8Units\u27e9\nFormat of \u27e8Units\u27e9: mm | cm | em | ex | in | pc | px | pt";
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SizeCssConverter that = (SizeCssConverter)obj;
        return this.nullable == that.nullable;
    }

    public int hashCode() {
        return Objects.hash(this.nullable);
    }

    public String toString() {
        return "SizeCssConverter[nullable=" + this.nullable + "]";
    }
}

