/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class UriCssConverter
extends AbstractCssConverter<URI> {
    private final String helpText;

    public UriCssConverter() {
        this(false, null);
    }

    public UriCssConverter(boolean nullable) {
        this(nullable, null);
    }

    public UriCssConverter(boolean nullable, String helpText) {
        super(nullable);
        this.helpText = helpText;
    }

    @Override
    public @Nullable String getHelpText() {
        return this.helpText;
    }

    @Override
    public @NonNull URI parseNonNull(@NonNull CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -12) {
            throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a URL value.", tt.getStartPosition());
        }
        try {
            return URI.create(tt.currentStringNonNull());
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a URL value.", tt.getStartPosition());
        }
    }

    @Override
    protected <TT extends URI> void produceTokensNonNull(@NonNull TT value, @Nullable IdSupplier idSupplier, @NonNull Consumer<CssToken> out) {
        out.accept(new CssToken(-12, value.toString()));
    }
}

