/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.function.AbstractCssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;

public abstract class AbstractMathCssFunction<T>
extends AbstractCssFunction<T> {
    public AbstractMathCssFunction(String name) {
        super(name);
    }

    protected @Nullable CssSize parseCalcSum(@NonNull T element, @NonNull CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        CssSize dim = this.parseCalcProduct(element, tt, functionProcessor);
        DefaultUnitConverter c = DefaultUnitConverter.getInstance();
        block4: while (true) {
            switch (tt.next()) {
                case 43: {
                    CssSize dim2 = this.parseCalcProduct(element, tt, functionProcessor);
                    if (dim2.getUnits().equals("") || dim.getUnits().equals(dim2.getUnits())) {
                        dim = CssSize.of(dim.getValue() + dim2.getValue(), dim.getUnits());
                        continue block4;
                    }
                    dim = CssSize.of(dim.getValue() + c.convert(dim2, dim.getUnits()), dim.getUnits());
                    continue block4;
                }
                case 45: {
                    CssSize dim2 = this.parseCalcProduct(element, tt, functionProcessor);
                    if (dim2.getUnits().equals("") || dim.getUnits().equals(dim2.getUnits())) {
                        dim = CssSize.of(dim.getValue() - dim2.getValue(), dim.getUnits());
                        continue block4;
                    }
                    dim = CssSize.of(dim.getValue() - c.convert(dim2, dim.getUnits()), dim.getUnits());
                    continue block4;
                }
            }
            break;
        }
        tt.pushBack();
        return dim;
    }

    protected @Nullable CssSize parseCalcProduct(@NonNull T element, @NonNull CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        CssSize dim = this.parseCalcValue(element, tt, functionProcessor);
        DefaultUnitConverter c = DefaultUnitConverter.getInstance();
        block4: while (true) {
            switch (tt.next()) {
                case 42: {
                    CssSize dim2 = this.parseCalcProduct(element, tt, functionProcessor);
                    if (dim2.getUnits().equals("") || dim.getUnits().equals(dim2.getUnits())) {
                        dim = CssSize.of(dim.getValue() * dim2.getValue(), dim.getUnits());
                        continue block4;
                    }
                    dim = c.convertSize(CssSize.of(dim.getConvertedValue() * dim2.getConvertedValue(), ""), dim.getUnits());
                    continue block4;
                }
                case 47: {
                    CssSize dim2 = this.parseCalcProduct(element, tt, functionProcessor);
                    if (dim2.getUnits().equals("") || dim.getUnits().equals(dim2.getUnits())) {
                        dim = CssSize.of(dim.getValue() / dim2.getValue(), dim.getUnits());
                        continue block4;
                    }
                    dim = c.convertSize(CssSize.of(dim.getConvertedValue() / dim2.getConvertedValue(), ""), dim.getUnits());
                    continue block4;
                }
            }
            break;
        }
        tt.pushBack();
        return dim;
    }

    protected void produceNumberPercentageOrDimension(@NonNull Consumer<CssToken> out, @NonNull CssSize dim, int line, int start, int end) {
        if ("%".equals(dim.getUnits())) {
            out.accept(new CssToken(-10, null, dim.getValue(), line, start, end));
        } else {
            out.accept(new CssToken(-11, dim.getUnits(), dim.getValue(), line, start, end));
        }
    }

    protected @Nullable CssSize parseCalcValue(@NonNull T element, @NonNull CssTokenizer tt, CssFunctionProcessor<T> functionProcessor) throws IOException, ParseException {
        switch (tt.next()) {
            case -9: {
                return CssSize.of(tt.currentNumberNonNull().doubleValue());
            }
            case -10: {
                return CssSize.of(tt.currentNumberNonNull().doubleValue(), "%");
            }
            case -11: {
                return CssSize.of(tt.currentNumberNonNull().doubleValue(), tt.currentStringNonNull());
            }
            case 40: {
                CssSize dim = this.parseCalcSum(element, tt, functionProcessor);
                tt.requireNextToken(41, this.getName() + "(): right bracket ')' expected.");
                return dim;
            }
            case -18: {
                String name = tt.currentString();
                tt.pushBack();
                ArrayList list = new ArrayList();
                functionProcessor.processToken(element, tt, list::add, new ArrayDeque());
                if (list.size() != 1) {
                    throw new ParseException(this.getName() + "(): function " + name + "() must return single value.", tt.getStartPosition());
                }
                CssToken token = (CssToken)list.getFirst();
                return switch (token.getType()) {
                    case -9 -> CssSize.of(token.getNumericValue().doubleValue());
                    case -10 -> CssSize.of(token.getNumericValue().doubleValue(), "%");
                    case -11 -> CssSize.of(token.getNumericValue().doubleValue(), token.getStringValue());
                    default -> throw new ParseException(this.getName() + "(): function " + name + "() must return numeric value.", tt.getStartPosition());
                };
            }
        }
        throw tt.createParseException(this.getName() + "(): number, percentage, dimension or (sum) expected.");
    }
}

