/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.function.AbstractStringCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;

public class ReplaceCssFunction<T>
extends AbstractStringCssFunction<T> {
    public static final String NAME = "replace";

    public ReplaceCssFunction() {
        this(NAME);
    }

    public ReplaceCssFunction(String name) {
        super(name);
    }

    @Override
    public void process(@NonNull T element, @NonNull CssTokenizer tt, @NonNull SelectorModel<T> model, @NonNull CssFunctionProcessor<T> functionProcessor, @NonNull Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "():  " + this.getName() + "() function expected.");
        if (!this.getName().equals(tt.currentStringNonNull())) {
            throw new ParseException(this.getName() + "(): " + this.getName() + "() function expected.", tt.getStartPosition());
        }
        int line = tt.getLineNumber();
        int start = tt.getStartPosition();
        String str = this.evalString(element, tt, this.getName(), functionProcessor);
        if (tt.next() != 44) {
            tt.pushBack();
        }
        String regex = this.evalString(element, tt, this.getName(), functionProcessor);
        if (tt.next() != 44) {
            tt.pushBack();
        }
        String repl = this.evalString(element, tt, this.getName(), functionProcessor);
        if (tt.next() != 41) {
            throw new ParseException(this.getName() + "():  right bracket ')' expected.", tt.getStartPosition());
        }
        try {
            String result = Pattern.compile(regex).matcher(str).replaceAll(repl);
            int end = tt.getEndPosition();
            out.accept(new CssToken(-4, result, null, line, start, end));
        }
        catch (IllegalArgumentException e) {
            ParseException ex = new ParseException(this.getName() + "(): " + e.getMessage(), tt.getStartPosition());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String getHelpText() {
        return this.getName() + "(\u3008string\u3009, \u3008regex\u3009, \u3008replacement\u3009)\n    Replaces matches of \u3008regex\u3009 by \u3008replacement\u3009 in the given \u3008string\u3009.";
    }
}

