/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.function;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.function.Consumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.function.AbstractCssFunction;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;

public class VarCssFunction<T>
extends AbstractCssFunction<T> {
    public static final String NAME = "var";

    public VarCssFunction() {
        this(NAME);
    }

    public VarCssFunction(String name) {
        super(name);
    }

    @Override
    public void process(@NonNull T element, @NonNull CssTokenizer tt, @NonNull SelectorModel<T> model, @NonNull CssFunctionProcessor<T> functionProcessor, @NonNull Consumer<CssToken> out, Deque<CssFunction<T>> recursionStack) throws IOException, ParseException {
        tt.requireNextToken(-18, this.getName() + "(): function var() expected.");
        if (!this.getName().equals(tt.currentString())) {
            throw tt.createParseException(this.getName() + "(): function var() expected.");
        }
        tt.requireNextToken(-2, this.getName() + "(): function custom-property-name expected.");
        String customPropertyName = tt.currentStringNonNull();
        ArrayList<CssToken> attrFallback = new ArrayList<CssToken>();
        if (tt.next() == 44) {
            while (tt.nextNoSkip() != -1 && tt.current() != 41) {
                attrFallback.add(tt.getToken());
            }
        }
        if (tt.current() != 41) {
            throw tt.createParseException(this.getName() + "(): right bracket expected.");
        }
        if (!customPropertyName.startsWith("--")) {
            throw tt.createParseException(this.getName() + "(): custom-property-name starting with two dashes \"--\" expected.");
        }
        ReadOnlyList customValue = (ReadOnlyList)functionProcessor.getCustomProperties().get(customPropertyName);
        recursionStack.push(this);
        if (customValue == null) {
            if (attrFallback.isEmpty()) {
                throw new ParseException(this.getName() + "(): Could not find a custom property with this name: \"" + customPropertyName + "\".", tt.getStartPosition());
            }
            functionProcessor.process(element, new ListCssTokenizer(attrFallback), out, recursionStack);
        } else {
            functionProcessor.process(element, new ListCssTokenizer((ReadOnlyList<CssToken>)customValue), out, recursionStack);
        }
        recursionStack.pop();
    }

    @Override
    public String getHelpText() {
        return "var(\u27e8custom-property-name\u27e9, \u27e8fallback\u27e9)\n    Retrieves a custom-property by name.\n    If the custom-property is not found, the fallback is used.\n    A custom-property is a property defined on a parent element (or on ':root').\n    The name of a custom-property must start with two dashes: '--'.";
    }
}

