/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.manager;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.base.converter.UriResolver;
import org.jhotdraw8.base.function.Consumer3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.css.ast.Declaration;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.css.ast.Stylesheet;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.function.CssFunction;
import org.jhotdraw8.css.manager.CssFunctionProcessor;
import org.jhotdraw8.css.manager.SimpleCssFunctionProcessor;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssParser;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;

public class SimpleStylesheetsManager<E>
implements StylesheetsManager<E> {
    private @Nullable String defaultNamespace;
    private @NonNull Supplier<CssParser> parserFactory = CssParser::new;
    private @NonNull UriResolver uriResolver = new SimpleUriResolver();
    private @NonNull SelectorModel<E> selectorModel;
    private @NonNull LinkedHashMap<Object, StylesheetEntry> userAgentList = new LinkedHashMap();
    private @NonNull LinkedHashMap<Object, StylesheetEntry> authorList = new LinkedHashMap();
    private @NonNull LinkedHashMap<Object, StylesheetEntry> inlineList = new LinkedHashMap();
    private final @NonNull Executor executor = ForkJoinPool.commonPool();
    private @Nullable Map<String, ImmutableList<CssToken>> cachedAuthorCustomProperties;
    private @Nullable Map<String, ImmutableList<CssToken>> cachedInlineCustomProperties;
    private @Nullable Map<String, ImmutableList<CssToken>> cachedUserAgentCustomProperties;
    private @NonNull Consumer3<Level, String, Throwable> logger = (l, s, t) -> {};
    private final @NonNull ConcurrentHashMap<OrderedPair<Stylesheet, QualifiedName>, List<StyleRule>> candidateRules = new ConcurrentHashMap();
    private @NonNull List<CssFunction<E>> functions = new ArrayList<CssFunction<E>>();

    public SimpleStylesheetsManager(@NonNull SelectorModel<E> selectorModel) {
        this(selectorModel, Collections.emptyList());
    }

    public SimpleStylesheetsManager(@NonNull SelectorModel<E> selectorModel, @NonNull List<CssFunction<E>> functions) {
        this.selectorModel = selectorModel;
        this.functions = functions;
    }

    private void doSetAttribute(@Nullable Stylesheet stylesheet, @NonNull SelectorModel<E> selectorModel1, @NonNull E elem, @NonNull StyleOrigin styleOrigin, @Nullable String namespace, @NonNull String name, @Nullable ImmutableList<CssToken> value, Map<String, ImmutableList<CssToken>> customProperties, @Nullable CssFunctionProcessor<E> functionProcessor) throws ParseException {
        if (value == null) {
            selectorModel1.setAttribute(elem, styleOrigin, namespace, name, null);
        } else if (functionProcessor != null) {
            ImmutableList<CssToken> processed = this.preprocessTerms(stylesheet, elem, functionProcessor, value);
            selectorModel1.setAttribute(elem, styleOrigin, namespace, name, (ReadOnlyList<CssToken>)processed);
        } else {
            selectorModel1.setAttribute(elem, styleOrigin, namespace, name, (ReadOnlyList<CssToken>)value);
        }
    }

    public void setSelectorModel(@NonNull SelectorModel<E> newValue) {
        this.selectorModel = newValue;
    }

    @Override
    public @NonNull SelectorModel<E> getSelectorModel() {
        return this.selectorModel;
    }

    @Override
    public @NonNull Consumer3<Level, String, Throwable> getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(@NonNull Consumer3<Level, String, Throwable> logger) {
        this.logger = logger;
    }

    @Override
    public void addStylesheet(@NonNull StyleOrigin origin, @NonNull URI stylesheetUri, @Nullable URI documentHome) {
        URI absolutizedUri = this.uriResolver.absolutize(documentHome, stylesheetUri);
        this.invalidate();
        this.getMap(origin).put(absolutizedUri, new StylesheetEntry(origin, absolutizedUri, documentHome, this.logger));
    }

    @Override
    public void addStylesheet(@NonNull StyleOrigin origin, @NonNull Stylesheet stylesheet) {
        this.invalidate();
        this.getMap(origin).put(stylesheet, new StylesheetEntry(origin, stylesheet, this.logger));
    }

    @Override
    public void addStylesheet(@NonNull StyleOrigin origin, @NonNull String str, @Nullable URI documentHome) {
        this.invalidate();
        this.getMap(origin).put(str, new StylesheetEntry(origin, str, null, documentHome, this.logger));
    }

    private void invalidate() {
        this.cachedAuthorCustomProperties = null;
        this.cachedInlineCustomProperties = null;
        this.cachedUserAgentCustomProperties = null;
        this.candidateRules.clear();
    }

    @Override
    public void clearStylesheets(@Nullable StyleOrigin origin) {
        if (origin == null) {
            this.authorList.clear();
            this.userAgentList.clear();
            this.inlineList.clear();
            this.invalidate();
        } else {
            this.getMap(origin).clear();
        }
    }

    private LinkedHashMap<Object, StylesheetEntry> getMap(@NonNull StyleOrigin origin) {
        return switch (origin) {
            case StyleOrigin.AUTHOR -> this.authorList;
            case StyleOrigin.USER_AGENT -> this.userAgentList;
            case StyleOrigin.INLINE -> this.inlineList;
            default -> throw new IllegalArgumentException("illegal origin:" + String.valueOf(origin));
        };
    }

    private void setMap(@NonNull StyleOrigin origin, LinkedHashMap<Object, StylesheetEntry> newValue) {
        switch (origin) {
            case AUTHOR: {
                this.authorList = newValue;
                break;
            }
            case USER_AGENT: {
                this.userAgentList = newValue;
                break;
            }
            case INLINE: {
                this.inlineList = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal origin:" + String.valueOf(origin));
            }
        }
    }

    @Override
    public <T> void setStylesheets(@NonNull StyleOrigin origin, @Nullable URI documentHome, @Nullable List<T> stylesheets) {
        this.invalidate();
        LinkedHashMap<Object, StylesheetEntry> oldMap = this.getMap(origin);
        if (stylesheets == null) {
            oldMap.clear();
            return;
        }
        LinkedHashMap<Object, StylesheetEntry> newMap = new LinkedHashMap<Object, StylesheetEntry>();
        for (T t : stylesheets) {
            if (t instanceof URI) {
                URI uri = (URI)t;
                URI absolutizedUri = this.uriResolver.absolutize(documentHome, uri);
                StylesheetEntry old = oldMap.get(absolutizedUri);
                newMap.put(absolutizedUri, new StylesheetEntry(origin, absolutizedUri, documentHome, this.logger));
                continue;
            }
            if (t instanceof String) {
                StylesheetEntry old = oldMap.get(t);
                newMap.put(t, old != null ? old : new StylesheetEntry(origin, (String)t, null, documentHome, this.logger));
                continue;
            }
            throw new IllegalArgumentException("illegal item " + String.valueOf(t));
        }
        this.setMap(origin, newMap);
    }

    protected @NonNull Collection<StylesheetEntry> getAuthorStylesheets() {
        return this.authorList.values();
    }

    protected @NonNull Collection<StylesheetEntry> getUserAgentStylesheets() {
        return this.userAgentList.values();
    }

    protected @NonNull Collection<StylesheetEntry> getInlineStylesheets() {
        return this.inlineList.values();
    }

    @Override
    public void applyStylesheetsTo(@NonNull E elem) {
        this.applyStylesheetsTo(Collections.singleton(elem));
    }

    @Override
    public void applyStylesheetsTo(@NonNull Iterable<E> iterable) {
        SelectorModel<E> selectorModel = this.getSelectorModel();
        Map<String, ImmutableList<CssToken>> customProperties = this.computeCustomProperties();
        CssFunctionProcessor<E> functionProcessor = this.functions.isEmpty() ? null : this.createCssFunctionProcessor(selectorModel, customProperties);
        ((Stream)StreamSupport.stream(iterable.spliterator(), false).toList().stream().parallel()).forEach(elem -> {
            Declaration d;
            selectorModel.reset(elem);
            for (ApplicableDeclaration entry : this.collectApplicableDeclarations(elem, this.getUserAgentStylesheets())) {
                try {
                    d = entry.declaration();
                    this.doSetAttribute(entry.stylesheet(), selectorModel, elem, StyleOrigin.USER_AGENT, d.getNamespace(), d.getPropertyName(), d.getTerms(), customProperties, functionProcessor);
                }
                catch (ParseException e) {
                    this.logger.accept((Object)Level.FINE, (Object)("user-agent stylesheet=" + String.valueOf(entry.stylesheet.getUri()) + " line=" + entry.declaration.getLineNumber()), (Object)e);
                }
            }
            for (ApplicableDeclaration entry : this.collectApplicableDeclarations(elem, this.getAuthorStylesheets())) {
                try {
                    d = entry.declaration();
                    this.doSetAttribute(entry.stylesheet(), selectorModel, elem, StyleOrigin.AUTHOR, d.getNamespace(), d.getPropertyName(), d.getTerms(), customProperties, functionProcessor);
                }
                catch (ParseException e) {
                    this.logger.accept((Object)Level.FINE, (Object)("external stylesheet=" + String.valueOf(entry.stylesheet.getUri()) + " line=" + entry.declaration.getLineNumber()), (Object)e);
                }
            }
            for (ApplicableDeclaration entry : this.collectApplicableDeclarations(elem, this.getInlineStylesheets())) {
                try {
                    d = entry.declaration();
                    this.doSetAttribute(entry.stylesheet(), selectorModel, elem, StyleOrigin.INLINE, d.getNamespace(), d.getPropertyName(), d.getTerms(), customProperties, functionProcessor);
                }
                catch (ParseException e) {
                    this.logger.accept((Object)Level.FINE, (Object)("internal stylesheet=" + String.valueOf(entry.stylesheet.getUri()) + " line=" + entry.declaration.getLineNumber()), (Object)e);
                }
            }
            CssParser parser = this.parserFactory.get();
            if (selectorModel.hasAttribute(elem, null, "style")) {
                HashMap<QualifiedName, ImmutableList<CssToken>> inlineDeclarations = new HashMap<QualifiedName, ImmutableList<CssToken>>();
                String styleValue = selectorModel.getAttributeAsString(elem, null, "style");
                if (styleValue != null) {
                    try {
                        for (Declaration d2 : parser.parseDeclarationList(styleValue)) {
                            if (d2.getTerms().isEmpty()) continue;
                            inlineDeclarations.put(new QualifiedName(d2.getNamespace(), d2.getPropertyName()), d2.getTerms());
                        }
                    }
                    catch (IOException ex) {
                        this.logger.accept((Object)Level.WARNING, (Object)("invalid inline style attribute on element. style=" + styleValue), null);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
                    }
                }
                Map<String, ImmutableList<CssToken>> inlineStyleAttrCustomProperties = Collections.emptyMap();
                for (Map.Entry entry : inlineDeclarations.entrySet()) {
                    try {
                        this.doSetAttribute(null, selectorModel, elem, StyleOrigin.INLINE, ((QualifiedName)entry.getKey()).namespace(), ((QualifiedName)entry.getKey()).name(), (ImmutableList<CssToken>)((ImmutableList)entry.getValue()), inlineStyleAttrCustomProperties, functionProcessor);
                    }
                    catch (ParseException e) {
                        this.logger.accept((Object)Level.WARNING, (Object)("error applying inline style attribute. style=" + styleValue), (Object)e);
                    }
                }
                inlineDeclarations.clear();
            }
        });
    }

    private @NonNull Map<String, ImmutableList<CssToken>> computeCustomProperties() {
        LinkedHashMap<String, ImmutableList<CssToken>> customProperties = new LinkedHashMap<String, ImmutableList<CssToken>>();
        customProperties.putAll(this.getUserAgentCustomProperties());
        customProperties.putAll(this.getAuthorCustomProperties());
        customProperties.putAll(this.getInlineCustomProperties());
        return customProperties;
    }

    private @NonNull Map<String, ImmutableList<CssToken>> getInlineCustomProperties() {
        if (this.cachedInlineCustomProperties == null) {
            this.cachedInlineCustomProperties = this.collectCustomProperties(this.getInlineStylesheets());
        }
        return this.cachedInlineCustomProperties;
    }

    private @NonNull Map<String, ImmutableList<CssToken>> getAuthorCustomProperties() {
        if (this.cachedAuthorCustomProperties == null) {
            this.cachedAuthorCustomProperties = this.collectCustomProperties(this.getAuthorStylesheets());
        }
        return this.cachedAuthorCustomProperties;
    }

    private @NonNull Map<String, ImmutableList<CssToken>> getUserAgentCustomProperties() {
        if (this.cachedUserAgentCustomProperties == null) {
            this.cachedUserAgentCustomProperties = this.collectCustomProperties(this.getUserAgentStylesheets());
        }
        return this.cachedUserAgentCustomProperties;
    }

    private List<ApplicableDeclaration> collectApplicableDeclarations(E elem, @NonNull Collection<StylesheetEntry> stylesheets) {
        ArrayList<ApplicableDeclaration> applicableDeclarations = new ArrayList<ApplicableDeclaration>();
        for (StylesheetEntry e : stylesheets) {
            Stylesheet s = e.getStylesheet();
            if (s == null) continue;
            this.collectApplicableDeclarations(elem, s, applicableDeclarations);
        }
        applicableDeclarations.sort(Comparator.comparingInt(ApplicableDeclaration::specificity));
        return applicableDeclarations;
    }

    private Iterable<StyleRule> getCandidateStyleRules(@NonNull Stylesheet s, @NonNull E elem) {
        QualifiedName qualifiedTypeName = this.getSelectorModel().getType(elem);
        String typeName = qualifiedTypeName.name();
        SimpleOrderedPair key = new SimpleOrderedPair((Object)s, (Object)qualifiedTypeName);
        return this.candidateRules.computeIfAbsent((OrderedPair<Stylesheet, QualifiedName>)key, k -> {
            ArrayList<StyleRule> candidates = new ArrayList<StyleRule>();
            for (StyleRule styleRule : s.getStyleRules()) {
                String candidateTypeName;
                TypeSelector typeSelector = styleRule.getSelectorGroup().matchesOnlyOnASpecificType();
                String string = candidateTypeName = typeSelector == null || !Objects.equals(typeSelector.getNamespacePattern(), "*") ? null : typeSelector.getType();
                if (candidateTypeName != null && !candidateTypeName.equals(typeName)) continue;
                candidates.add(styleRule);
            }
            return candidates;
        });
    }

    private @NonNull List<ApplicableDeclaration> collectApplicableDeclarations(@NonNull E elem, @NonNull Stylesheet s, @NonNull List<ApplicableDeclaration> applicableDeclarations) {
        SelectorModel<E> selectorModel = this.getSelectorModel();
        for (StyleRule r : this.getCandidateStyleRules(s, elem)) {
            Selector selector = r.getSelectorGroup().matchSelector(selectorModel, elem);
            if (null == selector) continue;
            for (Declaration d : r.getDeclarations()) {
                if (d.getTerms().isEmpty()) continue;
                applicableDeclarations.add(new ApplicableDeclaration(selector.getSpecificity(), s, d));
            }
        }
        return applicableDeclarations;
    }

    @Override
    public boolean applyStylesheetTo(@NonNull StyleOrigin styleOrigin, @NonNull Stylesheet s, @NonNull E elem, boolean suppressParseException) throws ParseException {
        SelectorModel<E> selectorModel = this.getSelectorModel();
        Map<String, ImmutableList<CssToken>> customProperties = this.collectCustomProperties(s);
        CssFunctionProcessor<E> processor = this.createCssFunctionProcessor(selectorModel, customProperties);
        List<ApplicableDeclaration> applicableDeclarations = this.collectApplicableDeclarations(elem, s, new ArrayList<ApplicableDeclaration>());
        if (applicableDeclarations.isEmpty()) {
            return false;
        }
        for (ApplicableDeclaration entry : applicableDeclarations) {
            Declaration d = entry.declaration();
            ImmutableList<CssToken> value = this.preprocessTerms(s, elem, processor, d.getTerms());
            try {
                ImmutableList<CssToken> appliedValue;
                CssToken first;
                CssToken cssToken = first = value.isEmpty() ? null : (CssToken)value.getFirst();
                if (first != null && first.getType() == -2) {
                    appliedValue = switch (first.getStringValueNonNull()) {
                        case "unset" -> null;
                        default -> value;
                    };
                } else {
                    appliedValue = value;
                }
                selectorModel.setAttribute(elem, styleOrigin, d.getNamespace(), d.getPropertyName(), (ReadOnlyList<CssToken>)appliedValue);
            }
            catch (ParseException e) {
                if (suppressParseException) {
                    this.logger.accept((Object)Level.WARNING, (Object)("error parsing stylesheet, uri=" + String.valueOf(s.getUri())), (Object)e);
                    continue;
                }
                throw e;
            }
        }
        return true;
    }

    private CssFunctionProcessor<E> createCssFunctionProcessor(SelectorModel<E> selectorModel, Map<String, ImmutableList<CssToken>> customProperties) {
        return new SimpleCssFunctionProcessor(this.functions, selectorModel, customProperties);
    }

    public @NonNull List<CssFunction<E>> getFunctions() {
        return this.functions;
    }

    public void setFunctions(@NonNull List<CssFunction<E>> functions) {
        this.functions = functions;
    }

    @Override
    public @NonNull String getHelpText() {
        StringBuilder buf = new StringBuilder();
        for (CssFunction<E> value : this.functions) {
            if (!buf.isEmpty()) {
                buf.append("\n");
            }
            buf.append(value.getHelpText());
        }
        return buf.toString();
    }

    private @NonNull Map<String, ImmutableList<CssToken>> collectCustomProperties(@NonNull Collection<StylesheetEntry> stylesheets) {
        LinkedHashMap<String, ImmutableList<CssToken>> customProperties = new LinkedHashMap<String, ImmutableList<CssToken>>();
        for (StylesheetEntry s : stylesheets) {
            Stylesheet stylesheet = s.getStylesheet();
            if (stylesheet == null) continue;
            this.collectCustomProperties(stylesheet, customProperties);
        }
        return customProperties;
    }

    private @NonNull Map<String, ImmutableList<CssToken>> collectCustomProperties(@NonNull Stylesheet s) {
        LinkedHashMap<String, ImmutableList<CssToken>> customProperties = new LinkedHashMap<String, ImmutableList<CssToken>>();
        this.collectCustomProperties(s, customProperties);
        return customProperties;
    }

    private void collectCustomProperties(@NonNull Stylesheet s, @NonNull Map<String, ImmutableList<CssToken>> customProperties) {
        for (StyleRule styleRule : s.getStyleRules()) {
            for (Declaration declaration : styleRule.getDeclarations()) {
                if (!declaration.getPropertyName().startsWith("--")) continue;
                customProperties.put(declaration.getPropertyName(), declaration.getTerms());
            }
        }
    }

    private @NonNull ImmutableList<CssToken> preprocessTerms(@Nullable Stylesheet stylesheet, @NonNull E elem, @NonNull CssFunctionProcessor<E> processor, @NonNull ImmutableList<CssToken> terms) {
        try {
            return processor.process(elem, (ReadOnlyList<CssToken>)terms);
        }
        catch (ParseException e) {
            this.logger.accept((Object)Level.WARNING, stylesheet == null ? "error preprocessing token from stylesheet" : "error preprocessing token from stylesheet, uri=" + String.valueOf(stylesheet.getUri()), (Object)e);
            return terms;
        }
    }

    @Override
    public List<StylesheetsManager.StylesheetInfo> getStylesheets() {
        ArrayList<StylesheetsManager.StylesheetInfo> list = new ArrayList<StylesheetsManager.StylesheetInfo>();
        list.addAll(this.userAgentList.values());
        list.addAll(this.authorList.values());
        list.addAll(this.inlineList.values());
        return list;
    }

    @Override
    public boolean hasStylesheets() {
        return !this.userAgentList.isEmpty() || !this.authorList.isEmpty() || !this.inlineList.isEmpty();
    }

    public @NonNull Supplier<CssParser> getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(@NonNull Supplier<CssParser> parserFactory) {
        this.parserFactory = parserFactory;
    }

    public @NonNull UriResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(@NonNull UriResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public @Nullable String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(@Nullable String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    protected class StylesheetEntry
    implements StylesheetsManager.StylesheetInfo {
        private final @Nullable URI uri;
        private final @NonNull StyleOrigin origin;
        private @Nullable FutureTask<Stylesheet> future;
        private @Nullable Stylesheet stylesheet;
        private final @NonNull Consumer3<Level, String, Throwable> logger;

        public StylesheetEntry(@NonNull StyleOrigin origin, @Nullable URI stylesheetUri, @NonNull URI documentHome, Consumer3<Level, String, Throwable> logger) {
            this.origin = origin;
            this.uri = stylesheetUri;
            this.future = new FutureTask<Stylesheet>(() -> {
                CssParser p = new CssParser();
                URI stylesheetHome = SimpleStylesheetsManager.this.uriResolver.getParent(stylesheetUri);
                Stylesheet s = p.parseStylesheet(stylesheetUri, stylesheetHome);
                logger.accept((Object)Level.FINE, (Object)("Parsed " + String.valueOf(stylesheetUri) + "\n#rules: " + s.getStyleRules().size() + ", #errors: " + p.getParseExceptions().size()), null);
                List<ParseException> parseExceptions = p.getParseExceptions();
                if (!parseExceptions.isEmpty()) {
                    logger.accept((Object)Level.FINE, (Object)("Parsed " + String.valueOf(stylesheetUri) + "\nExceptions:\n  " + parseExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n  "))), null);
                }
                return s;
            });
            this.logger = logger;
            SimpleStylesheetsManager.this.executor.execute(this.future);
        }

        public StylesheetEntry(@NonNull StyleOrigin origin, @NonNull Stylesheet stylesheet, Consumer3<Level, String, Throwable> logger) {
            this.logger = logger;
            this.uri = null;
            this.origin = origin;
            this.stylesheet = stylesheet;
        }

        public StylesheetEntry(@NonNull StyleOrigin origin, @Nullable String str, @Nullable URI stylesheetUri, @NonNull URI documentHome, Consumer3<Level, String, Throwable> logger) {
            this.logger = logger;
            this.uri = null;
            this.origin = origin;
            this.future = new FutureTask<Stylesheet>(() -> {
                CssParser p = SimpleStylesheetsManager.this.parserFactory.get();
                Stylesheet s = p.parseStylesheet(str, stylesheetUri, documentHome);
                logger.accept((Object)Level.FINE, (Object)("Parsed " + str + "\nRules: " + String.valueOf(s.getStyleRules())), null);
                List<ParseException> parseExceptions = p.getParseExceptions();
                if (!parseExceptions.isEmpty()) {
                    logger.accept((Object)Level.FINE, (Object)("Parsed " + str + "\nExceptions:\n  " + parseExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n  "))), null);
                }
                return s;
            });
            SimpleStylesheetsManager.this.executor.execute(this.future);
        }

        @Override
        public @Nullable URI getUri() {
            return this.uri;
        }

        @Override
        public @NonNull StyleOrigin getOrigin() {
            return this.origin;
        }

        @Override
        public @Nullable Stylesheet getStylesheet() {
            if (this.future != null) {
                try {
                    this.stylesheet = this.future.get();
                    this.future = null;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException ex) {
                    this.logger.accept((Object)Level.WARNING, (Object)"failed to get stylesheet", (Object)ex);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
                    this.stylesheet = null;
                    this.future = null;
                }
            }
            return this.stylesheet;
        }
    }

    private record ApplicableDeclaration(int specificity, @NonNull Stylesheet stylesheet, @NonNull Declaration declaration) {
    }
}

