/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.manager;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.function.Consumer3;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.css.ast.Stylesheet;
import org.jhotdraw8.css.model.SelectorModel;

public interface StylesheetsManager<E> {
    default public void addStylesheet(@NonNull StyleOrigin origin, @NonNull URI url) {
        this.addStylesheet(origin, url, url);
    }

    public void addStylesheet(@NonNull StyleOrigin var1, @NonNull URI var2, @NonNull URI var3);

    public void addStylesheet(@NonNull StyleOrigin var1, @NonNull Stylesheet var2);

    public void addStylesheet(@NonNull StyleOrigin var1, @NonNull String var2, @Nullable URI var3);

    default public void applyStylesheetsTo(@NonNull Iterable<E> iterable) {
        ((Stream)StreamSupport.stream(iterable.spliterator(), false).toList().stream().parallel()).forEach(this::applyStylesheetsTo);
    }

    public void clearStylesheets(StyleOrigin var1);

    default public <T> void setStylesheets(StyleOrigin origin, List<T> stylesheets) {
        this.setStylesheets(origin, null, stylesheets);
    }

    public <T> void setStylesheets(StyleOrigin var1, URI var2, List<T> var3);

    public void applyStylesheetsTo(E var1);

    public @NonNull SelectorModel<E> getSelectorModel();

    public boolean applyStylesheetTo(StyleOrigin var1, Stylesheet var2, E var3, boolean var4) throws ParseException;

    default public boolean matchesElement(@NonNull Stylesheet s, E elem) {
        SelectorModel<E> selectorModel = this.getSelectorModel();
        for (StyleRule r : s.getStyleRules()) {
            if (!r.getSelectorGroup().matches(selectorModel, elem)) continue;
            return true;
        }
        return false;
    }

    default public List<StyleRule> getMatchingRulesForElement(@NonNull Stylesheet s, E elem) {
        ArrayList<StyleRule> matchingRules = new ArrayList<StyleRule>();
        SelectorModel<E> selectorModel = this.getSelectorModel();
        for (StyleRule r : s.getStyleRules()) {
            if (!r.getSelectorGroup().matches(selectorModel, elem)) continue;
            matchingRules.add(r);
        }
        return matchingRules;
    }

    public @NonNull Consumer3<Level, String, Throwable> getLogger();

    public void setLogger(@NonNull Consumer3<Level, String, Throwable> var1);

    public String getHelpText();

    public List<StylesheetInfo> getStylesheets();

    default public boolean hasStylesheets() {
        return !this.getStylesheets().isEmpty();
    }

    public static interface StylesheetInfo {
        public URI getUri();

        public StyleOrigin getOrigin();

        public Stylesheet getStylesheet();
    }
}

