/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.model;

import java.text.ParseException;
import java.util.List;
import java.util.Set;
import javafx.beans.property.MapProperty;
import javafx.css.StyleOrigin;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.value.QualifiedName;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jhotdraw8.icollection.readonly.ReadOnlySet;

public interface SelectorModel<T> {
    public @NonNull MapProperty<String, Set<T>> additionalPseudoClassStatesProperty();

    default public boolean attributeValueContains(@NonNull T element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.contains(substring);
    }

    default public boolean attributeValueContainsWord(@NonNull T element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String word) {
        String value = this.getAttributeAsString(element, namespacePattern, attributeName);
        if (value != null) {
            String[] words;
            for (String s : words = value.split("\\s+")) {
                if (!word.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean attributeValueEndsWith(@NonNull T element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.endsWith(substring);
    }

    default public boolean attributeValueEquals(@NonNull T element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String attributeValue) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.equals(attributeValue);
    }

    default public boolean attributeValueStartsWith(@NonNull T element, @Nullable String namespacePattern, @NonNull String attributeName, @NonNull String substring) {
        String actualValue = this.getAttributeAsString(element, namespacePattern, attributeName);
        return actualValue != null && actualValue.startsWith(substring);
    }

    default public @Nullable String getAttributeAsString(@NonNull T element, @Nullable String namespacePattern, @NonNull String name) {
        return this.getAttributeAsString(element, StyleOrigin.USER, namespacePattern, name);
    }

    default public @Nullable String getAttributeAsString(@NonNull T element, @Nullable StyleOrigin origin, @Nullable String namespacePattern, @NonNull String name) {
        List<CssToken> list = this.getAttribute(element, origin, namespacePattern, name);
        if (list == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (CssToken t : list) {
            buf.append(t.fromToken());
        }
        return buf.toString();
    }

    public @Nullable List<CssToken> getAttribute(@NonNull T var1, @Nullable StyleOrigin var2, @Nullable String var3, @NonNull String var4);

    public @NonNull Set<QualifiedName> getAttributeNames(@NonNull T var1);

    public @NonNull Set<QualifiedName> getComposedAttributeNames(@NonNull T var1);

    public @NonNull Set<QualifiedName> getDecomposedAttributeNames(@NonNull T var1);

    public @Nullable String getId(@NonNull T var1);

    public @Nullable T getParent(@NonNull T var1);

    public @Nullable T getPreviousSibling(@NonNull T var1);

    public @NonNull ReadOnlySet<String> getStyleClasses(@NonNull T var1);

    public @NonNull ReadOnlySet<String> getPseudoClasses(@NonNull T var1);

    public @Nullable QualifiedName getType(@NonNull T var1);

    public boolean hasAttribute(@NonNull T var1, @Nullable String var2, @NonNull String var3);

    public boolean hasId(@NonNull T var1, @NonNull String var2);

    public boolean hasPseudoClass(@NonNull T var1, @NonNull String var2);

    public boolean hasStyleClass(@NonNull T var1, @NonNull String var2);

    public boolean hasType(@NonNull T var1, @Nullable String var2, @NonNull String var3);

    public void reset(T var1);

    public void setAttribute(@NonNull T var1, @NonNull StyleOrigin var2, @Nullable String var3, @NonNull String var4, @Nullable ReadOnlyList<CssToken> var5) throws ParseException;
}

