/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.SimpleUriResolver;
import org.jhotdraw8.base.converter.UriResolver;
import org.jhotdraw8.css.ast.AbstractAttributeSelector;
import org.jhotdraw8.css.ast.AdjacentSiblingCombinator;
import org.jhotdraw8.css.ast.AndCombinator;
import org.jhotdraw8.css.ast.AtRule;
import org.jhotdraw8.css.ast.ChildCombinator;
import org.jhotdraw8.css.ast.ClassSelector;
import org.jhotdraw8.css.ast.DashMatchSelector;
import org.jhotdraw8.css.ast.Declaration;
import org.jhotdraw8.css.ast.DescendantCombinator;
import org.jhotdraw8.css.ast.EqualsMatchSelector;
import org.jhotdraw8.css.ast.ExistsMatchSelector;
import org.jhotdraw8.css.ast.FunctionPseudoClassSelector;
import org.jhotdraw8.css.ast.GeneralSiblingCombinator;
import org.jhotdraw8.css.ast.IdSelector;
import org.jhotdraw8.css.ast.IncludeMatchSelector;
import org.jhotdraw8.css.ast.NegationPseudoClassSelector;
import org.jhotdraw8.css.ast.PrefixMatchSelector;
import org.jhotdraw8.css.ast.PseudoClassSelector;
import org.jhotdraw8.css.ast.Rule;
import org.jhotdraw8.css.ast.SelectNothingSelector;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.SelectorGroup;
import org.jhotdraw8.css.ast.SimplePseudoClassSelector;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.css.ast.Stylesheet;
import org.jhotdraw8.css.ast.SubstringMatchSelector;
import org.jhotdraw8.css.ast.SuffixMatchSelector;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.ast.UniversalSelector;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.ListCssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;

public class CssParser {
    public static final String ANY_NAMESPACE_PREFIX = "*";
    public static final String DEFAULT_NAMESPACE = "|";
    public static final String NAMESPACE_AT_RULE = "namespace";
    private final SequencedMap<String, String> prefixToNamespaceMap = new LinkedHashMap<String, String>();
    private @NonNull List<ParseException> exceptions = new ArrayList<ParseException>();
    private @Nullable URI stylesheetHome;
    private @Nullable URI stylesheetUri;
    private @NonNull UriResolver uriResolver = new SimpleUriResolver();
    private boolean strict = false;
    private final @NonNull SequencedMap<Selector, Selector> deduplicatedSelectors = new LinkedHashMap<Selector, Selector>();

    private @NonNull FunctionPseudoClassSelector createFunctionPseudoClassSelector(@NonNull CssTokenizer tt) throws IOException, ParseException {
        String ident;
        tt.requireNextToken(-18, "FunctionPseudoClassSelector: Function expected");
        switch (ident = tt.currentStringNonNull()) {
            case "not": {
                SimpleSelector simpleSelector = this.parseSimpleSelector(tt);
                tt.requireNextToken(41, "Could not parse the \":not()\" pseudo-class selector, because it does not end with a closing bracket ')' character.");
                return new NegationPseudoClassSelector(tt.getSourceLocator(), ident, simpleSelector);
            }
        }
        block10: while (tt.next() != -1) {
            switch (tt.current()) {
                case 41: {
                    tt.pushBack();
                    break block10;
                }
                case 123: 
                case 125: {
                    ParseException ex = tt.createParseException("Could not parse the \":" + ident + "()\" pseudo-class selector, because it contains unexpected curly bracket '{', '}' characters.");
                    tt.pushBack();
                    throw ex;
                }
                default: {
                    continue block10;
                }
            }
        }
        tt.requireNextToken(41, "Could not parse the \":" + ident + "()\" pseudo-class selector, because it does not end with a closing bracket ')' character.");
        return new FunctionPseudoClassSelector(tt.getSourceLocator(), ident);
    }

    public @NonNull List<ParseException> getParseExceptions() {
        return this.exceptions;
    }

    private void interpretAtRule(AtRule atRule, int position) {
        if (NAMESPACE_AT_RULE.equals(atRule.getAtKeyword())) {
            String prefix;
            ListCssTokenizer tt = new ListCssTokenizer(atRule.getHeader());
            if (tt.next() == -2) {
                prefix = tt.currentStringNonNull();
            } else {
                prefix = DEFAULT_NAMESPACE;
                tt.pushBack();
            }
            if (tt.next() == -12 || tt.current() == -4) {
                String namespace = tt.currentStringNonNull();
                this.prefixToNamespaceMap.put(prefix, namespace);
            }
        } else {
            this.exceptions.add(new ParseException("Could not parse the At-Rule \"@" + atRule.getAtKeyword() + "\".", position));
        }
    }

    private @NonNull AtRule parseAtRule(@NonNull CssTokenizer tt) throws IOException, ParseException {
        SourceLocator sourceLocator = tt.getSourceLocator();
        if (tt.nextNoSkip() != -3) {
            throw tt.createParseException("Could not parse the At-Rule, because it does not start with an '@' character.");
        }
        String atKeyword = tt.currentStringNonNull();
        tt.next();
        ArrayList<CssToken> header = new ArrayList<CssToken>();
        while (tt.current() != -1 && tt.current() != 123 && tt.current() != 59) {
            tt.pushBack();
            this.parseComponentValue(tt, header);
            tt.nextNoSkip();
        }
        ArrayList<CssToken> body = new ArrayList<CssToken>();
        if (tt.current() == 59) {
            return new AtRule(sourceLocator, atKeyword, header, body);
        }
        tt.pushBack();
        this.parseCurlyBlock(tt, body);
        body.removeFirst();
        body.removeLast();
        return new AtRule(sourceLocator, atKeyword, header, body);
    }

    private @NonNull AbstractAttributeSelector parseAttributeSelector(@NonNull CssTokenizer tt) throws IOException, ParseException {
        AbstractAttributeSelector selector;
        tt.requireNextNoSkip(91, "Could not parse an AttributeSelector because it does not start with an opening square bracket '[' character.");
        String prefixOrName = null;
        String namespacePattern = null;
        String attributeName = null;
        if (tt.nextNoSkip() == -2) {
            prefixOrName = tt.currentStringNonNull();
        } else if (tt.current() == 42) {
            prefixOrName = ANY_NAMESPACE_PREFIX;
            tt.requireNextNoSkip(124, "Could not parse a '*|' namespace prefix because it does not contain the '|' character.");
            tt.pushBack();
        } else {
            tt.pushBack();
        }
        if (tt.nextNoSkip() == 124) {
            namespacePattern = prefixOrName == null ? TypeSelector.WITHOUT_NAMESPACE : this.resolveNamespacePrefix(prefixOrName, tt);
            tt.requireNextNoSkip(-2, "Could not parse an AttributeSelector because it does not contain an attribute name after the square bracket '[' character.");
            attributeName = tt.currentStringNonNull();
        } else {
            namespacePattern = ANY_NAMESPACE_PREFIX;
            attributeName = prefixOrName;
            tt.pushBack();
        }
        SourceLocator sourceLocator = tt.getSourceLocator();
        switch (tt.nextNoSkip()) {
            case 61: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4) {
                    throw tt.createParseException("Could not parse an EqualityMatch because it does not contain an attribute value after the '=' character.");
                }
                selector = new EqualsMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case -19: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4 && tt.current() != -9) {
                    throw tt.createParseException("Could not parse an IncludeMatch because it does not contain an attribute value after the '~=' characters.");
                }
                selector = new IncludeMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case -20: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4 && tt.current() != -9) {
                    throw tt.createParseException("Could not parse a DashMatch because it does not contain an attribute value after the '-=' characters.");
                }
                selector = new DashMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case -21: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4 && tt.current() != -9) {
                    throw tt.createParseException("Could not parse a PrefixMatch because it does not contain an attribute value after the '^=' characters.");
                }
                selector = new PrefixMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case -22: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4 && tt.current() != -9) {
                    throw tt.createParseException("Could not parse a SuffixMatch because it does not contain an attribute after the '$=' characters.");
                }
                selector = new SuffixMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case -23: {
                if (tt.nextNoSkip() != -2 && tt.current() != -4 && tt.current() != -9) {
                    throw tt.createParseException("Could not parse a SubstringMatch because it does not contain an attribute after the '*=' characters.");
                }
                selector = new SubstringMatchSelector(sourceLocator, namespacePattern, attributeName, tt.currentStringNonNull());
                break;
            }
            case 93: {
                selector = new ExistsMatchSelector(sourceLocator, namespacePattern, attributeName);
                tt.pushBack();
                break;
            }
            default: {
                throw tt.createParseException("Could not parse an AttributeSelector because it does contain an unexpected operand: " + String.valueOf(tt.getToken()) + ".");
            }
        }
        if (tt.nextNoSkip() != 93) {
            throw tt.createParseException("Could not parse an AttributeSelector because it does not end with a closing square bracket ']' character.");
        }
        return selector;
    }

    private void parseBracketedTerms(@NonNull CssTokenizer tt, @NonNull List<CssToken> terms, int endBracket) throws IOException, ParseException {
        terms.add(new CssToken(tt.current(), tt.currentString(), tt.currentNumber(), tt.getLineNumber(), tt.getStartPosition(), tt.getEndPosition()));
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        tt.pushBack();
        block6: while (tt.nextNoSkip() != -1 && tt.current() != endBracket) {
            switch (tt.current()) {
                case -15: 
                case -14: {
                    continue block6;
                }
                case -6: {
                    throw tt.createParseException("Could not parse BracketedTerms because it contains a bad URI.");
                }
                case -5: {
                    throw tt.createParseException("Could not parse BracketedTerms because it contains a bad String.");
                }
                case 59: {
                    throw tt.createParseException("Could not parse BracketedTerms because of an unexpected semicolon ';' character.");
                }
            }
            tt.pushBack();
            this.parseTerms(tt, terms);
        }
        terms.add(new CssToken(tt.current(), tt.currentString(), tt.currentNumber(), tt.getLineNumber(), tt.getStartPosition(), tt.getEndPosition()));
    }

    private void parseComponentValue(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        switch (tt.nextNoSkip()) {
            case 123: {
                tt.pushBack();
                this.parseCurlyBlock(tt, preservedTokens);
                break;
            }
            case 40: {
                tt.pushBack();
                this.parseRoundBlock(tt, preservedTokens);
                break;
            }
            case 91: {
                tt.pushBack();
                this.parseSquareBlock(tt, preservedTokens);
                break;
            }
            case -18: {
                tt.pushBack();
                this.parseFunctionBlock(tt, preservedTokens);
                break;
            }
            default: {
                tt.pushBack();
                this.parsePreservedToken(tt, preservedTokens);
            }
        }
    }

    private void parseCurlyBlock(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        if (tt.nextNoSkip() != 123) {
            throw tt.createParseException("Could not parse a CurlyBlock because it does not start with an opening curly bracket '{' character.");
        }
        preservedTokens.add(tt.getToken());
        while (tt.nextNoSkip() != -1 && tt.current() != 125) {
            tt.pushBack();
            this.parseComponentValue(tt, preservedTokens);
        }
        if (tt.current() != 125) {
            throw tt.createParseException("Could not parse a CurlyBlock because it does not end with an closing curly bracket '}' character.");
        }
        preservedTokens.add(tt.getToken());
    }

    private @NonNull Declaration parseDeclaration(@NonNull CssTokenizer tt) throws IOException, ParseException {
        String name;
        String namespace;
        if (tt.nextNoSkip() != -2) {
            throw tt.createParseException("Could not parse a Declaration because it does not start with an identifier.");
        }
        int startPos = tt.getStartPosition();
        int lineNumber = tt.getLineNumber();
        String prefixOrName = tt.currentStringNonNull();
        if (tt.nextNoSkip() == 124) {
            namespace = this.resolveNamespacePrefix(prefixOrName, tt);
            tt.requireNextNoSkip(-2, "Could not parse a Declaration because it does not contain a property name.");
            name = tt.currentStringNonNull();
        } else {
            namespace = null;
            name = prefixOrName;
            tt.pushBack();
        }
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        if (tt.current() != 58) {
            throw tt.createParseException("Could not parse a Declaration because it does not contain a colon ':' character.");
        }
        List<CssToken> terms = this.parseTerms(tt);
        int endPos = terms.isEmpty() ? tt.getStartPosition() : terms.getLast().getEndPos();
        return new Declaration(tt.getSourceLocator(), namespace, name, terms, startPos, endPos, lineNumber);
    }

    public @NonNull List<Declaration> parseDeclarationList(@NonNull String css) throws IOException {
        return this.parseDeclarationList(new StringReader(css));
    }

    public @NonNull List<Declaration> parseDeclarationList(Reader css) throws IOException {
        this.exceptions = new ArrayList<ParseException>();
        StreamCssTokenizer tt = new StreamCssTokenizer(css, null);
        try {
            return this.parseDeclarationList(tt);
        }
        catch (ParseException ex) {
            this.exceptions.add(ex);
            return new ArrayList<Declaration>();
        }
    }

    private @NonNull List<Declaration> parseDeclarationList(@NonNull CssTokenizer tt) throws IOException, ParseException {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        block6: while (tt.next() != -1 && tt.current() != 125) {
            switch (tt.current()) {
                case -2: {
                    tt.pushBack();
                    try {
                        declarations.add(this.parseDeclaration(tt));
                    }
                    catch (ParseException e) {
                        this.exceptions.add(e);
                    }
                    continue block6;
                }
                case 59: {
                    continue block6;
                }
            }
            throw tt.createParseException("Could not parse a DeclarationList because it does not contain a Declaration or At-rule.");
        }
        tt.pushBack();
        return declarations;
    }

    private void parseFunctionBlock(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        if (tt.nextNoSkip() != -18) {
            throw tt.createParseException("Could not parse a FunctionBlock because it does not start with a function.");
        }
        preservedTokens.add(tt.getToken());
        while (tt.nextNoSkip() != -1 && tt.current() != 41) {
            tt.pushBack();
            this.parseComponentValue(tt, preservedTokens);
        }
        if (tt.current() != 41) {
            throw tt.createParseException("Could not parse a FunctionBlock because it does not end with a closing bracket ')' character.");
        }
        preservedTokens.add(tt.getToken());
    }

    private void parsePreservedToken(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        if (tt.nextNoSkip() == -1) {
            throw tt.createParseException("Could not parse a PreservedToken because of unexpected end-of-file.");
        }
        preservedTokens.add(tt.getToken());
    }

    private @NonNull PseudoClassSelector parsePseudoClassSelector(@NonNull CssTokenizer tt) throws IOException, ParseException {
        if (tt.nextNoSkip() != 58) {
            throw tt.createParseException("Could not parse a PseudoClassSelector because it does not start with a colon ':' character.");
        }
        if (tt.nextNoSkip() != -2 && tt.current() != -18) {
            throw tt.createParseException("Could not parse a PseudoClassSelector because it does not contain an identifier or a function after the colon ':' character.");
        }
        if (tt.current() == -18) {
            tt.pushBack();
            return this.createFunctionPseudoClassSelector(tt);
        }
        return new SimplePseudoClassSelector(tt.getSourceLocator(), tt.currentString());
    }

    private void parseRoundBlock(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        if (tt.nextNoSkip() != 40) {
            throw tt.createParseException("Could not parse a RoundBlock because it does not start with an opening bracket '(' character.");
        }
        preservedTokens.add(tt.getToken());
        while (tt.nextNoSkip() != -1 && tt.current() != 41) {
            tt.pushBack();
            this.parseComponentValue(tt, preservedTokens);
        }
        if (tt.current() != 41) {
            throw tt.createParseException("Could not parse a RoundBlock because it does not end with an closing bracket ')' character.");
        }
        preservedTokens.add(tt.getToken());
    }

    private @NonNull Selector parseSelector(@NonNull CssTokenizer tt) throws IOException, ParseException {
        SimpleSelector simpleSelector;
        Selector selector = simpleSelector = this.parseSimpleSelector(tt);
        block5: while (tt.nextNoSkip() != -1 && tt.current() != 123 && tt.current() != 44) {
            boolean potentialDescendantCombinator = false;
            if (tt.current() == -16) {
                potentialDescendantCombinator = true;
                this.skipWhitespaceAndComments(tt);
            }
            if (tt.current() == -1 || tt.current() == 123 || tt.current() == 44) break;
            SourceLocator sourceLocator = tt.getSourceLocator();
            switch (tt.current()) {
                case 62: {
                    selector = new ChildCombinator(sourceLocator, simpleSelector, this.parseSelector(tt));
                    continue block5;
                }
                case 43: {
                    selector = new AdjacentSiblingCombinator(sourceLocator, simpleSelector, this.parseSelector(tt));
                    continue block5;
                }
                case 126: {
                    selector = new GeneralSiblingCombinator(sourceLocator, simpleSelector, this.parseSelector(tt));
                    continue block5;
                }
            }
            tt.pushBack();
            if (potentialDescendantCombinator) {
                selector = new DescendantCombinator(sourceLocator, simpleSelector, this.parseSelector(tt));
                continue;
            }
            selector = new AndCombinator(sourceLocator, simpleSelector, this.parseSelector(tt));
        }
        tt.pushBack();
        return (Selector)this.deduplicatedSelectors.computeIfAbsent(selector, Function.identity());
    }

    public @NonNull SelectorGroup parseSelectorGroup(@NonNull CssTokenizer tt) throws IOException, ParseException {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        selectors.add(this.parseSelector(tt));
        while (tt.nextNoSkip() != -1 && tt.current() != 123) {
            this.skipWhitespaceAndComments(tt);
            if (tt.current() != 44) {
                throw tt.createParseException("Could not parse a SelectorGroup because it does not contain a comma ',' character.");
            }
            tt.nextNoSkip();
            this.skipWhitespaceAndComments(tt);
            tt.pushBack();
            selectors.add(this.parseSelector(tt));
        }
        tt.pushBack();
        return new SelectorGroup(tt.getSourceLocator(), selectors);
    }

    private @NonNull SimpleSelector parseSimpleSelector(@NonNull CssTokenizer tt) throws IOException, ParseException {
        SimpleSelector simpleSelector = this.parseSimpleSelector0(tt);
        return (SimpleSelector)this.deduplicatedSelectors.computeIfAbsent(simpleSelector, Function.identity());
    }

    private @NonNull SimpleSelector parseSimpleSelector0(@NonNull CssTokenizer tt) throws IOException {
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        try {
            SourceLocator sourceLocator = tt.getSourceLocator();
            switch (tt.current()) {
                case 42: {
                    if (tt.nextNoSkip() == 124) {
                        tt.requireNextNoSkip(-2, "element name expected after *|");
                        return new TypeSelector(sourceLocator, ANY_NAMESPACE_PREFIX, tt.currentStringNonNull());
                    }
                    tt.pushBack();
                    return new UniversalSelector(sourceLocator);
                }
                case 124: {
                    tt.requireNextNoSkip(-2, "element name expected after |");
                    return new TypeSelector(sourceLocator, TypeSelector.WITHOUT_NAMESPACE, tt.currentStringNonNull());
                }
                case -2: {
                    String typeOrPrefix = tt.currentStringNonNull();
                    if (tt.nextNoSkip() == 124) {
                        tt.requireNextNoSkip(-2, "element name expected after " + typeOrPrefix + DEFAULT_NAMESPACE);
                        return new TypeSelector(sourceLocator, this.resolveNamespacePrefix(typeOrPrefix, tt), tt.currentStringNonNull());
                    }
                    tt.pushBack();
                    return new TypeSelector(sourceLocator, this.resolveNamespacePrefix(DEFAULT_NAMESPACE, tt), typeOrPrefix);
                }
                case -8: {
                    return new IdSelector(sourceLocator, tt.currentString());
                }
                case 46: {
                    if (tt.nextNoSkip() != -2) {
                        throw tt.createParseException("Could not parse a SimpleSelector because it does not contain an identifier.");
                    }
                    return new ClassSelector(sourceLocator, tt.currentString());
                }
                case 58: {
                    tt.pushBack();
                    return this.parsePseudoClassSelector(tt);
                }
                case 91: {
                    tt.pushBack();
                    return this.parseAttributeSelector(tt);
                }
                case 123: {
                    tt.pushBack();
                    throw tt.createParseException("Could not parse a SimpleSelector because it contains an unexpected curly bracket '{' character.");
                }
            }
            throw tt.createParseException("Could not parse a SimpleSelector because it contains an unexpected " + String.valueOf(tt.getToken()) + ".");
        }
        catch (ParseException e) {
            this.exceptions.add(e);
            return new SelectNothingSelector(tt.getSourceLocator());
        }
    }

    private void parseSquareBlock(@NonNull CssTokenizer tt, @NonNull List<CssToken> preservedTokens) throws IOException, ParseException {
        if (tt.nextNoSkip() != 91) {
            throw tt.createParseException("Could not parse a SquareBlock because it does not start with an opening square bracket '[' character.");
        }
        preservedTokens.add(tt.getToken());
        while (tt.nextNoSkip() != -1 && tt.current() != 93) {
            tt.pushBack();
            this.parseComponentValue(tt, preservedTokens);
        }
        if (tt.current() != 93) {
            throw tt.createParseException("Could not parse a SquareBlock because it does not end with a closing square bracket ']' character.");
        }
        preservedTokens.add(tt.getToken());
    }

    private @NonNull StyleRule parseStyleRule(@NonNull CssTokenizer tt) throws IOException, ParseException {
        SelectorGroup selectorGroup;
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        SourceLocator sourceLocator = tt.getSourceLocator();
        if (tt.current() == 123) {
            tt.pushBack();
            selectorGroup = new SelectorGroup(sourceLocator, new UniversalSelector(sourceLocator));
        } else {
            tt.pushBack();
            selectorGroup = this.parseSelectorGroup(tt);
        }
        this.skipWhitespaceAndComments(tt);
        if (tt.nextNoSkip() != 123) {
            throw tt.createParseException("Could not parse a StyleRule because it does not contain an opening curly bracket '{' character.");
        }
        List<Declaration> declarations = this.parseDeclarationList(tt);
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        if (tt.current() != 125) {
            throw tt.createParseException("Could not parse a StyleRule because it does not end with a closing curly bracket '}' character.");
        }
        return new StyleRule(sourceLocator, selectorGroup, declarations);
    }

    public @NonNull Stylesheet parseStylesheet(@NonNull URI stylesheetUri, @Nullable URI stylesheetHome) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stylesheetUri.toURL().openConnection().getInputStream(), StandardCharsets.UTF_8));){
            Stylesheet stylesheet = this.parseStylesheet(in, stylesheetUri, stylesheetHome);
            return stylesheet;
        }
    }

    public @NonNull Stylesheet parseStylesheet(@NonNull String css, @Nullable URI stylesheetUri, @Nullable URI stylesheetHome) throws IOException {
        return this.parseStylesheet(new StringReader(css), stylesheetUri, stylesheetHome);
    }

    public @NonNull Selector parseSelector(@NonNull String css) throws ParseException {
        try {
            return this.parseSelector(new StreamCssTokenizer(new StringReader(css)));
        }
        catch (IOException e) {
            throw (ParseException)new ParseException("Could not parse a Selector.", 0).initCause(e);
        }
    }

    public @NonNull Stylesheet parseStylesheet(Reader css, @Nullable URI stylesheetUri, @Nullable URI stylesheetHome) throws IOException {
        this.exceptions = new ArrayList<ParseException>();
        StreamCssTokenizer tt = new StreamCssTokenizer(css, stylesheetUri);
        return this.parseStylesheet(tt, stylesheetUri, stylesheetHome);
    }

    public @NonNull Stylesheet parseStylesheet(@NonNull CssTokenizer tt, @Nullable URI stylesheetUri, @Nullable URI stylesheetHome) throws IOException {
        this.setStylesheetUri(stylesheetUri);
        this.setStylesheetHome(stylesheetHome);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        block6: while (tt.nextNoSkip() != -1) {
            try {
                switch (tt.current()) {
                    case -17: 
                    case -16: 
                    case -15: 
                    case -14: {
                        continue block6;
                    }
                    case -3: {
                        tt.pushBack();
                        int startPosition = tt.getStartPosition();
                        AtRule r = this.parseAtRule(tt);
                        this.interpretAtRule(r, startPosition);
                        rules.add(r);
                        continue block6;
                    }
                }
                tt.pushBack();
                StyleRule r = this.parseStyleRule(tt);
                rules.add(r);
            }
            catch (ParseException e) {
                this.exceptions.add(e);
            }
        }
        return new Stylesheet(this.getStylesheetUri(), rules);
    }

    private @NonNull List<CssToken> parseTerms(@NonNull CssTokenizer tt) throws IOException, ParseException {
        ArrayList<CssToken> terms = new ArrayList<CssToken>();
        return this.parseTerms(tt, terms);
    }

    private @NonNull List<CssToken> parseTerms(@NonNull CssTokenizer tt, List<CssToken> terms) throws IOException, ParseException {
        tt.nextNoSkip();
        this.skipWhitespaceAndComments(tt);
        tt.pushBack();
        block8: while (tt.nextNoSkip() != -1 && tt.current() != 125 && tt.current() != 93 && tt.current() != 59) {
            switch (tt.current()) {
                case -15: 
                case -14: {
                    continue block8;
                }
                case -6: {
                    throw tt.createParseException("Could not parse Terms because it contains a bad URI.");
                }
                case -5: {
                    throw tt.createParseException("Could not parse Terms because it contains a bad String.");
                }
                case 123: {
                    this.parseBracketedTerms(tt, terms, 125);
                    continue block8;
                }
                case 91: {
                    this.parseBracketedTerms(tt, terms, 93);
                    continue block8;
                }
                case -12: {
                    terms.add(new CssToken(tt.current(), this.absolutizeUri(tt.currentStringNonNull()), tt.currentNumber(), tt.getLineNumber(), tt.getStartPosition(), tt.getEndPosition()));
                    continue block8;
                }
            }
            terms.add(new CssToken(tt.current(), tt.currentString(), tt.currentNumber(), tt.getLineNumber(), tt.getStartPosition(), tt.getEndPosition()));
        }
        tt.pushBack();
        return terms;
    }

    private @NonNull String absolutizeUri(@NonNull String relativeUri) {
        if (this.stylesheetHome == null) {
            return relativeUri;
        }
        try {
            return this.uriResolver.absolutize(this.stylesheetHome, new URI(relativeUri)).toString();
        }
        catch (URISyntaxException e) {
            return relativeUri;
        }
    }

    private @Nullable String resolveNamespacePrefix(@Nullable String namespacePrefix, CssTokenizer tt) throws ParseException {
        String string = namespacePrefix;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ANY_NAMESPACE_PREFIX}, (Object)string, n)) {
            case -1 -> ANY_NAMESPACE_PREFIX;
            case 0 -> ANY_NAMESPACE_PREFIX;
            default -> {
                String s = (String)this.prefixToNamespaceMap.get(namespacePrefix);
                if (s == null) {
                    if (this.strict) {
                        throw tt.createParseException("Could not find a namespace with namespacePrefix=\"" + namespacePrefix + "\".");
                    }
                    s = ANY_NAMESPACE_PREFIX;
                }
                yield s;
            }
        };
    }

    private void skipWhitespaceAndComments(@NonNull CssTokenizer tt) throws IOException {
        while (tt.current() == -16 || tt.current() == -15 || tt.current() == -14 || tt.current() == -17 || tt.current() == -7) {
            tt.nextNoSkip();
        }
    }

    public @Nullable URI getStylesheetUri() {
        return this.stylesheetUri;
    }

    public void setStylesheetUri(@Nullable URI stylesheetUri) {
        this.stylesheetUri = stylesheetUri;
    }

    public @Nullable URI getStylesheetHome() {
        return this.stylesheetHome;
    }

    public void setStylesheetHome(@Nullable URI stylesheetHome) {
        this.stylesheetHome = stylesheetHome;
    }

    public @NonNull UriResolver getUriResolver() {
        return this.uriResolver;
    }

    public void setUriResolver(@NonNull UriResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

