/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.parser.CssToken;

public interface CssTokenizer {
    default public @Nullable String currentValue() {
        return switch (this.current()) {
            case -3 -> "@" + this.currentString();
            case -7 -> "bad comment";
            case -5 -> "bad string";
            case -6 -> "bad uri";
            case -15 -> "<!--";
            case -14 -> "-->";
            case -24 -> "|";
            case -18, -17, -13, -12, -8, -4, -2 -> this.currentString();
            case -20 -> "|=";
            case -11 -> String.valueOf(this.currentNumber()) + this.currentString();
            case -1 -> "eof";
            case -19 -> "~=";
            case -9 -> String.valueOf(this.currentNumber());
            case -10 -> String.valueOf(this.currentNumber()) + "%";
            case -21 -> "^=";
            case -16 -> " ";
            case -23 -> "*=";
            case -22 -> "$=";
            default -> Character.toString((char)this.current());
        };
    }

    public @Nullable Number currentNumber();

    default public @NonNull Number currentNumberNonNull() {
        Number number = this.currentNumber();
        if (number == null) {
            throw new AssertionError((Object)"currentNumber");
        }
        return number;
    }

    public @Nullable String currentString();

    default public @NonNull String currentStringNonNull() {
        String str = this.currentString();
        if (str == null) {
            throw new AssertionError((Object)"currentString");
        }
        return str;
    }

    public int current();

    public int getLineNumber();

    public @Nullable SourceLocator getSourceLocator();

    public int getStartPosition();

    public int getEndPosition();

    public int getNextPosition();

    public int next() throws IOException;

    public int nextNoSkip() throws IOException;

    default public void skipIfPresent(int ttype) throws IOException {
        if (this.next() != ttype) {
            this.pushBack();
        }
    }

    default public boolean nextIsIdentNone() throws IOException {
        return this.next() == -2 && this.currentStringNonNull().equals("none");
    }

    default public boolean currentIsIdentNone() {
        return this.current() == -2 && this.currentStringNonNull().equals("none");
    }

    default public void requireNextToken(int ttype, String message) throws ParseException, IOException {
        if (this.next() != ttype) {
            throw this.createParseException(message);
        }
    }

    default public ParseException createParseException(String message) {
        return new ParseException(message + " Found: '" + String.valueOf(this.getToken()) + "'.", this.getStartPosition());
    }

    default public void requireNextNoSkip(int ttype, String message) throws ParseException, IOException {
        if (this.nextNoSkip() != ttype) {
            throw this.createParseException(message);
        }
    }

    public void pushBack();

    public CssToken getToken();

    default public @NonNull List<CssToken> toTokenList() throws IOException {
        ArrayList<CssToken> list = new ArrayList<CssToken>();
        while (this.nextNoSkip() != -1) {
            list.add(this.getToken());
        }
        return list;
    }
}

