/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.parser;

import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;

public class ListCssTokenizer
implements CssTokenizer {
    private final @NonNull ImmutableList<CssToken> in;
    private int index = 0;
    private boolean pushBack = true;
    private CssToken current;
    private static final CssToken EOF = new CssToken(-1);

    public ListCssTokenizer(@NonNull List<CssToken> in) {
        this((ReadOnlyList<CssToken>)VectorList.copyOf(in));
    }

    public ListCssTokenizer(@NonNull ReadOnlyList<CssToken> in) {
        this.in = VectorList.copyOf(in);
        this.current = in.isEmpty() ? EOF : (CssToken)in.get(0);
    }

    @Override
    public @Nullable Number currentNumber() {
        return this.current.getNumericValue();
    }

    @Override
    public @Nullable String currentString() {
        return this.current.getStringValue();
    }

    @Override
    public int current() {
        return this.current.getType();
    }

    @Override
    public int getLineNumber() {
        return this.current.getLineNumber();
    }

    @Override
    public @Nullable SourceLocator getSourceLocator() {
        return new SourceLocator(this.getStartPosition(), this.getLineNumber(), null);
    }

    @Override
    public int getStartPosition() {
        return this.current.getStartPos();
    }

    @Override
    public int getEndPosition() {
        return this.current.getEndPos();
    }

    @Override
    public int getNextPosition() {
        if (this.pushBack) {
            return this.current.getStartPos();
        }
        return this.current.getEndPos();
    }

    @Override
    public int next() {
        this.skipWhitespace();
        while (this.skipComment()) {
            this.skipWhitespace();
        }
        return this.nextNoSkip();
    }

    @Override
    public int nextNoSkip() {
        if (this.pushBack) {
            this.pushBack = false;
        } else {
            ++this.index;
            this.current = this.index < this.in.size() ? (CssToken)this.in.get(this.index) : EOF;
        }
        return this.current.getType();
    }

    private void skipWhitespace() {
        while (this.nextNoSkip() == -16 || this.current.getType() == -15 || this.current.getType() == -14) {
        }
        this.pushBack();
    }

    private boolean skipComment() {
        boolean didSkip = false;
        while (this.nextNoSkip() == -17 || this.current.getType() == -7) {
            didSkip = true;
        }
        this.pushBack();
        return didSkip;
    }

    @Override
    public void pushBack() {
        this.pushBack = true;
    }

    @Override
    public CssToken getToken() {
        return this.current;
    }
}

