/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.value;

import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.css.value.CssSizeWithUnits;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.css.value.UnitConverter;

public class CssSize {
    public static final @Nullable CssSize ZERO = new CssSize(0.0);
    public static final CssSize ONE = new CssSize(1.0);
    private final double value;

    CssSize(double value) {
        this.value = value;
    }

    public static CssSize of(double value, @Nullable String units) {
        boolean hasDefaultUnits;
        boolean bl = hasDefaultUnits = units == null || units.equals("");
        if (hasDefaultUnits) {
            if (value == 0.0) {
                return ZERO;
            }
            if (value == 1.0) {
                return ONE;
            }
        }
        return hasDefaultUnits ? new CssSize(value) : new CssSizeWithUnits(value, units);
    }

    public static CssSize of(double value) {
        return CssSize.of(value, null);
    }

    public static @NonNull CssSize max(@NonNull CssSize a, @NonNull CssSize b) {
        return a.getConvertedValue() >= b.getConvertedValue() ? a : b;
    }

    public static @NonNull CssSize min(@NonNull CssSize a, @NonNull CssSize b) {
        return a.getConvertedValue() <= b.getConvertedValue() ? a : b;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CssSize)) {
            return false;
        }
        CssSize other = (CssSize)obj;
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(other.value)) {
            return false;
        }
        return Objects.equals(this.getUnits(), other.getUnits());
    }

    public double getConvertedValue() {
        return DefaultUnitConverter.getInstance().convert(this, "");
    }

    public double getConvertedValue(@NonNull UnitConverter converter) {
        return converter.convert(this, "");
    }

    public double getConvertedValue(@NonNull UnitConverter converter, @NonNull String units) {
        return converter.convert(this, units);
    }

    public @NonNull String getUnits() {
        return "";
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.getUnits());
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    public @NonNull String toString() {
        return "CssSize{" + this.value + this.getUnits() + "}";
    }

    public @NonNull CssSize subtract(@NonNull CssSize that) {
        return this.subtract(that, DefaultUnitConverter.getInstance());
    }

    public @NonNull CssSize add(@NonNull CssSize that) {
        return this.add(that, DefaultUnitConverter.getInstance());
    }

    public @NonNull CssSize subtract(@NonNull CssSize that, @NonNull UnitConverter unitConverter) {
        return CssSize.of(this.value - unitConverter.convert(that, this.getUnits()), this.getUnits());
    }

    public @NonNull CssSize add(@NonNull CssSize that, @NonNull UnitConverter unitConverter) {
        return CssSize.of(this.value + unitConverter.convert(that, this.getUnits()), this.getUnits());
    }

    public @NonNull CssSize abs() {
        return this.value >= 0.0 ? this : CssSize.of(Math.abs(this.value), this.getUnits());
    }

    public @NonNull CssSize multiply(double factor) {
        return CssSize.of(this.value * factor, this.getUnits());
    }

    public @NonNull CssSize divide(double divisor) {
        return CssSize.of(this.value / divisor, this.getUnits());
    }
}

