/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.value;

import java.util.Objects;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.css.value.CssSize;

public interface UnitConverter {
    public static final String DEFAULT = "";
    public static final String CENTIMETERS = "cm";
    public static final String DEGREES = "deg";
    public static final String EM = "em";
    public static final String EX = "ex";
    public static final String INCH = "in";
    public static final String MILLIMETERS = "mm";
    public static final String QUARTER_MILLIMETERS = "Q";
    public static final String PERCENTAGE = "%";
    public static final String PICAS = "pc";
    public static final String PIXELS = "px";
    public static final String POINTS = "pt";
    public static final String VIEWPORT_WIDTH_PERCENTAGE = "vw";
    public static final String VIEWPORT_HEIGHT_PERCENTAGE = "vh";
    public static final String VIEWPORT_MIN_PERCENTAGE = "vmin";
    public static final String VIEWPORT_MAX_PERCENTAGE = "vmax";

    default public double getDpi() {
        return 96.0;
    }

    default public double getViewportWidth() {
        return 1024.0;
    }

    default public double getViewportHeight() {
        return 768.0;
    }

    default public double getPercentageFactor() {
        return 100.0;
    }

    default public double getFactor(@NonNull String unit) {
        double factor = switch (unit) {
            case PERCENTAGE -> this.getPercentageFactor();
            case CENTIMETERS -> 2.54 / this.getDpi();
            case MILLIMETERS -> 25.4 / this.getDpi();
            case QUARTER_MILLIMETERS -> 6.35 / this.getDpi();
            case INCH -> 1.0 / this.getDpi();
            case POINTS -> 72.0 / this.getDpi();
            case PICAS -> 864.0 / this.getDpi();
            case EM -> 1.0 / this.getFontSize();
            case EX -> 1.0 / this.getFontXHeight();
            case VIEWPORT_HEIGHT_PERCENTAGE -> 100.0 / this.getViewportHeight();
            case VIEWPORT_WIDTH_PERCENTAGE -> 100.0 / this.getViewportWidth();
            case VIEWPORT_MIN_PERCENTAGE -> 100.0 / Math.min(this.getViewportHeight(), this.getViewportWidth());
            case VIEWPORT_MAX_PERCENTAGE -> 100.0 / Math.max(this.getViewportHeight(), this.getViewportWidth());
            default -> 1.0;
        };
        return factor;
    }

    default public double getFontSize() {
        return 12.0;
    }

    default public double getFontXHeight() {
        return 8.0;
    }

    default public double convert(double value, @NonNull String inputUnit, @NonNull String outputUnit) {
        if (value == 0.0 || Objects.equals(inputUnit, outputUnit)) {
            return value;
        }
        return value * this.getFactor(outputUnit) / this.getFactor(inputUnit);
    }

    default public @NonNull CssSize convertSize(double value, @NonNull String inputUnit, @NonNull String outputUnit) {
        return CssSize.of(this.convert(value, inputUnit, outputUnit), outputUnit);
    }

    default public double convert(@NonNull CssSize value, @NonNull String outputUnit) {
        return this.convert(value.getValue(), value.getUnits(), outputUnit);
    }

    default public @NonNull CssSize convertSize(@NonNull CssSize value, @NonNull String outputUnit) {
        return CssSize.of(this.convert(value.getValue(), value.getUnits(), outputUnit), outputUnit);
    }
}

