/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.List;
import org.jhotdraw8.css.ast.Rule;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jspecify.annotations.Nullable;

public class AtRule
extends Rule {
    private final String atKeyword;
    private final ImmutableList<CssToken> header;
    private final ImmutableList<CssToken> body;

    public AtRule(@Nullable SourceLocator sourceLocator, String atKeyword, List<? extends CssToken> header, List<? extends CssToken> body) {
        super(sourceLocator);
        this.atKeyword = atKeyword;
        this.header = VectorList.copyOf(header);
        this.body = VectorList.copyOf(body);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("AtRule: ");
        buf.append(this.atKeyword);
        if (!this.header.isEmpty()) {
            buf.append(" ");
            for (CssToken t : this.header) {
                buf.append(t.fromToken());
            }
        }
        if (!this.header.isEmpty() && !this.body.isEmpty()) {
            buf.append(" ");
        }
        if (!this.body.isEmpty()) {
            buf.append("{");
            for (CssToken t : this.body) {
                buf.append(t.fromToken());
            }
            buf.append("}");
        }
        return buf.toString();
    }

    public String getAtKeyword() {
        return this.atKeyword;
    }

    public ReadOnlyList<CssToken> getHeader() {
        return this.header;
    }

    public ReadOnlyList<CssToken> getBody() {
        return this.body;
    }
}

