/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.List;
import org.jhotdraw8.css.ast.AbstractSyntaxTree;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jspecify.annotations.Nullable;

public class Declaration
extends AbstractSyntaxTree {
    private final @Nullable String namespace;
    private final String propertyName;
    private final ImmutableList<CssToken> terms;
    private final int startPos;
    private final int endPos;
    private final int lineNumber;

    public Declaration(@Nullable SourceLocator sourceLocator, @Nullable String namespace, String propertyName, List<CssToken> terms, int startPos, int endPos, int lineNumber) {
        super(sourceLocator);
        this.namespace = namespace;
        this.propertyName = propertyName;
        this.terms = VectorList.copyOf(terms);
        this.startPos = startPos;
        this.endPos = endPos;
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public @Nullable String getNamespace() {
        return this.namespace;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ImmutableList<CssToken> getTerms() {
        return this.terms;
    }

    public String getTermsAsString() {
        StringBuilder buf = new StringBuilder();
        for (CssToken t : this.terms) {
            buf.append(t.toString());
        }
        return buf.toString();
    }

    public String toString() {
        return this.propertyName + ":" + this.getTermsAsString();
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }
}

