/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.function.Consumer;
import org.jhotdraw8.css.ast.Combinator;
import org.jhotdraw8.css.ast.Selector;
import org.jhotdraw8.css.ast.SimpleSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.TypeSelector;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jspecify.annotations.Nullable;

public class DescendantCombinator
extends Combinator {
    public DescendantCombinator(@Nullable SourceLocator sourceLocator, SimpleSelector first, Selector second) {
        super(sourceLocator, first, second);
    }

    @Override
    public String toString() {
        return String.valueOf(this.first) + ".isAncestorOf(" + String.valueOf(this.second) + ")";
    }

    @Override
    public <T> @Nullable T match(SelectorModel<T> model, T element) {
        T secondMatch = this.second.match(model, element);
        if (secondMatch != null) {
            T parentElement = model.getParent(element);
            while (parentElement != null) {
                T firstMatch = this.first.match(model, parentElement);
                if (firstMatch != null) {
                    return secondMatch;
                }
                parentElement = model.getParent(parentElement);
            }
        }
        return null;
    }

    @Override
    public int getSpecificity() {
        return this.first.getSpecificity() + this.second.getSpecificity();
    }

    @Override
    public void produceTokens(Consumer<CssToken> consumer) {
        this.first.produceTokens(consumer);
        consumer.accept(new CssToken(-16, " "));
        this.second.produceTokens(consumer);
    }

    @Override
    public @Nullable TypeSelector matchesOnlyOnASpecificType() {
        return this.second.matchesOnlyOnASpecificType();
    }
}

