/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.css.ast.AbstractAttributeSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jspecify.annotations.Nullable;

public class ExistsMatchSelector
extends AbstractAttributeSelector {
    private final @Nullable String namespacePattern;
    private final String attributeName;

    public ExistsMatchSelector(@Nullable SourceLocator sourceLocator, @Nullable String namespacePattern, String attributeName) {
        super(sourceLocator);
        this.namespacePattern = namespacePattern;
        this.attributeName = attributeName;
    }

    @Override
    protected <T> @Nullable T match(SelectorModel<T> model, T element) {
        return (T)(model.hasAttribute(element, this.namespacePattern, this.attributeName) ? element : null);
    }

    public String toString() {
        return "[" + this.namespacePattern + ":" + this.attributeName + "]";
    }

    @Override
    public void produceTokens(Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(91));
        if (!"*".equals(this.namespacePattern)) {
            if (this.namespacePattern != null) {
                consumer.accept(new CssToken(-2, this.namespacePattern));
            }
            consumer.accept(new CssToken(124));
        }
        consumer.accept(new CssToken(-2, this.attributeName));
        consumer.accept(new CssToken(93));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistsMatchSelector that = (ExistsMatchSelector)o;
        return Objects.equals(this.namespacePattern, that.namespacePattern) && this.attributeName.equals(that.attributeName);
    }

    public int hashCode() {
        return Objects.hash(this.namespacePattern, this.attributeName);
    }
}

