/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.css.ast.PseudoClassSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jspecify.annotations.Nullable;

public class FunctionPseudoClassSelector
extends PseudoClassSelector {
    private final String functionIdentifier;

    public FunctionPseudoClassSelector(@Nullable SourceLocator sourceLocator, String functionIdentifier) {
        super(sourceLocator);
        this.functionIdentifier = functionIdentifier;
    }

    public String toString() {
        return "FunctionPseudoClass:" + this.functionIdentifier + "()";
    }

    @Override
    public <T> @Nullable T match(SelectorModel<T> model, @Nullable T element) {
        return element != null && model.hasPseudoClass(element, this.functionIdentifier) ? (T)element : null;
    }

    public String getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    @Override
    public void produceTokens(Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(58));
        consumer.accept(new CssToken(-18, this.functionIdentifier));
        consumer.accept(new CssToken(41));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionPseudoClassSelector that = (FunctionPseudoClassSelector)o;
        return this.functionIdentifier.equals(that.functionIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.functionIdentifier);
    }
}

