/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.css.ast.PseudoClassSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jspecify.annotations.Nullable;

public class SimplePseudoClassSelector
extends PseudoClassSelector {
    private final String pseudoClass;

    public SimplePseudoClassSelector(@Nullable SourceLocator sourceLocator, String pseudoClass) {
        super(sourceLocator);
        this.pseudoClass = pseudoClass;
    }

    public String toString() {
        return "PseudoClass:" + this.pseudoClass;
    }

    @Override
    public <T> @Nullable T match(SelectorModel<T> model, @Nullable T element) {
        return element != null && model.hasPseudoClass(element, this.pseudoClass) ? (T)element : null;
    }

    @Override
    public void produceTokens(Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(58));
        consumer.accept(new CssToken(-2, this.pseudoClass));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimplePseudoClassSelector that = (SimplePseudoClassSelector)o;
        return this.pseudoClass.equals(that.pseudoClass);
    }

    public int hashCode() {
        return Objects.hash(this.pseudoClass);
    }
}

