/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.jhotdraw8.css.ast.AbstractSyntaxTree;
import org.jhotdraw8.css.ast.Rule;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.ast.StyleRule;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.readonly.ReadOnlyList;
import org.jspecify.annotations.Nullable;

public class Stylesheet
extends AbstractSyntaxTree {
    private final @Nullable URI uri;
    private final ImmutableList<Rule> rules;
    private final ImmutableList<StyleRule> styleRules;

    public Stylesheet(@Nullable URI uri, List<Rule> rules) {
        super(new SourceLocator(0, 1, uri));
        this.uri = uri;
        this.rules = VectorList.copyOf(rules);
        this.styleRules = VectorList.copyOf((Iterable)rules.stream().filter(r -> r instanceof StyleRule).map(r -> (StyleRule)r).collect(Collectors.toList()));
    }

    public @Nullable URI getUri() {
        return this.uri;
    }

    public ReadOnlyList<StyleRule> getStyleRules() {
        return this.styleRules;
    }

    public ReadOnlyList<Rule> getRules() {
        return this.rules;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (Rule r : this.rules) {
            if (first) {
                first = false;
            } else {
                buf.append('\n');
            }
            buf.append(r.toString());
        }
        return buf.toString();
    }
}

