/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.ast;

import java.util.Objects;
import java.util.function.Consumer;
import org.jhotdraw8.css.ast.AbstractAttributeSelector;
import org.jhotdraw8.css.ast.SourceLocator;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.css.parser.CssToken;
import org.jspecify.annotations.Nullable;

public class SuffixMatchSelector
extends AbstractAttributeSelector {
    private final @Nullable String namespacePattern;
    private final String attributeName;
    private final String suffix;

    public SuffixMatchSelector(@Nullable SourceLocator sourceLocator, @Nullable String namespacePattern, String attributeName, String suffix) {
        super(sourceLocator);
        this.namespacePattern = namespacePattern;
        this.attributeName = attributeName;
        this.suffix = suffix;
    }

    @Override
    protected <T> @Nullable T match(SelectorModel<T> model, T element) {
        return (T)(model.attributeValueEndsWith(element, this.namespacePattern, this.attributeName, this.suffix) ? element : null);
    }

    public String toString() {
        return "[" + this.attributeName + "&=" + this.suffix + "]";
    }

    @Override
    public void produceTokens(Consumer<CssToken> consumer) {
        consumer.accept(new CssToken(91));
        if (!"*".equals(this.namespacePattern)) {
            if (this.namespacePattern != null) {
                consumer.accept(new CssToken(-2, this.namespacePattern));
            }
            consumer.accept(new CssToken(124));
        }
        consumer.accept(new CssToken(-2, this.attributeName));
        consumer.accept(new CssToken(-22));
        consumer.accept(new CssToken(-4, this.suffix));
        consumer.accept(new CssToken(93));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuffixMatchSelector that = (SuffixMatchSelector)o;
        return Objects.equals(this.namespacePattern, that.namespacePattern) && this.attributeName.equals(that.attributeName) && this.suffix.equals(that.suffix);
    }

    public int hashCode() {
        return Objects.hash(this.namespacePattern, this.attributeName, this.suffix);
    }
}

