/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class BooleanCssConverter
extends AbstractCssConverter<Boolean> {
    private final String trueString = "true";
    private final String falseString = "false";

    public BooleanCssConverter(boolean nullable) {
        super(nullable);
    }

    @Override
    public Boolean parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        String s;
        tt.requireNextToken(-2, "\u27e8Boolean\u27e9 identifier expected.");
        return switch (s = tt.currentStringNonNull()) {
            case "true" -> Boolean.TRUE;
            case "false" -> Boolean.FALSE;
            default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a boolean value.", tt.getStartPosition());
        };
    }

    @Override
    public <TT extends Boolean> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-2, value.booleanValue() ? "true" : "false"));
    }

    @Override
    public @Nullable String getHelpText() {
        if (this.isNullable()) {
            return "Format of \u27e8NullableBoolean\u27e9: none\uff5ctrue\uff5cfalse";
        }
        return "Format of \u27e8Boolean\u27e9: true\uff5cfalse";
    }
}

