/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class LongCssConverter
extends AbstractCssConverter<Long> {
    public LongCssConverter(boolean nullable) {
        super(nullable);
    }

    @Override
    public Long parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        switch (tt.next()) {
            case -9: {
                break;
            }
            default: {
                throw tt.createParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a long value.");
            }
        }
        return tt.currentNumberNonNull().longValue();
    }

    @Override
    public <TT extends Long> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-9, value));
    }

    @Override
    public @Nullable String getHelpText() {
        return "Format of \u27e8Long\u27e9: \u27e8integer\u27e9";
    }
}

