/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.CssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.icollection.readonly.ReadOnlyMap;
import org.jspecify.annotations.Nullable;

public class MappedCssConverter<E>
implements CssConverter<E> {
    private final Map<String, E> fromStringMap = new LinkedHashMap<String, E>();
    private final Map<E, String> toStringMap = new LinkedHashMap<E, String>();
    private final boolean nullable;
    private final String name;

    public MappedCssConverter(String name, Map<String, E> fromStringMap) {
        this(name, fromStringMap, false);
    }

    public MappedCssConverter(String name, ReadOnlyMap<String, E> fromStringMap) {
        this(name, fromStringMap, false);
    }

    public MappedCssConverter(String name, Map<String, E> fromStringMap, boolean nullable) {
        for (Map.Entry<String, E> entry : fromStringMap.entrySet()) {
            this.fromStringMap.putIfAbsent(entry.getKey(), entry.getValue());
            this.toStringMap.putIfAbsent(entry.getValue(), entry.getKey());
        }
        this.name = name;
        this.nullable = nullable;
    }

    public MappedCssConverter(String name, ReadOnlyMap<String, E> fromStringMap, boolean nullable) {
        this(name, fromStringMap.asMap(), nullable);
    }

    @Override
    public @Nullable E parse(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -2) {
            throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a value.", tt.getStartPosition());
        }
        String identifier = tt.currentString();
        if (this.nullable && "none".equals(identifier)) {
            return null;
        }
        E e = this.fromStringMap.get(identifier);
        if (e == null) {
            throw new ParseException("Could not convert the string=\"" + identifier + "\" to a value.", 0);
        }
        return e;
    }

    @Override
    public @Nullable String getHelpText() {
        StringBuilder buf = new StringBuilder("Format of \u27e8");
        buf.append(this.name).append("\u27e9: ");
        boolean first = true;
        if (this.nullable) {
            buf.append("none");
            first = false;
        }
        for (String f : this.toStringMap.values()) {
            if (first) {
                first = false;
            } else {
                buf.append('\uff5c');
            }
            buf.append(f);
        }
        return buf.toString();
    }

    @Override
    public <TT extends E> void produceTokens(@Nullable TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> consumer) {
        if (value == null) {
            if (!this.nullable) {
                throw new IllegalArgumentException("Could not convert the value=null to a string.");
            }
            consumer.accept(new CssToken(-2, "none"));
        } else {
            String s = this.toStringMap.get(value);
            if (s == null) {
                throw new IllegalArgumentException("Could not convert the value=\"" + String.valueOf(value) + "\" to a string.");
            }
            consumer.accept(new CssToken(-2, s));
        }
    }

    public @Nullable E getDefaultValue() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }
}

