/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class PercentageCssConverter
extends AbstractCssConverter<Double> {
    public PercentageCssConverter(boolean nullable) {
        super(nullable);
    }

    @Override
    public Double parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        return switch (tt.next()) {
            case -9 -> tt.currentNumberNonNull().doubleValue();
            case -10 -> tt.currentNumberNonNull().doubleValue() / 100.0;
            case -2 -> {
                double v1 = switch (tt.currentStringNonNull()) {
                    case "INF" -> Double.POSITIVE_INFINITY;
                    case "-INF" -> Double.NEGATIVE_INFINITY;
                    case "NaN" -> Double.NaN;
                    default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a percentage value.", tt.getStartPosition());
                };
                double value = v1;
                yield value;
            }
            default -> throw new ParseException("Could not convert " + String.valueOf(tt.getToken()) + " to a percentage value.", tt.getStartPosition());
        };
    }

    @Override
    public <TT extends Double> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        double v = value.doubleValue();
        if (value.isInfinite()) {
            out.accept(new CssToken(-2, v > 0.0 ? "INF" : "-INF"));
        } else if (value.isNaN()) {
            out.accept(new CssToken(-2, "NaN"));
        } else {
            out.accept(new CssToken(-10, v * 100.0));
        }
    }

    @Override
    public @Nullable String getHelpText() {
        if (this.isNullable()) {
            return "Format of \u27e8NullablePercentage\u27e9: none\uff5c\u27e8fraction\u27e9\uff5c\u27e8percentage\u27e9%";
        }
        return "Format of \u27e8Percentage\u27e9: \u27e8fraction\u27e9\uff5c\u27e8percentage\u27e9%";
    }
}

