/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.css.converter.AbstractCssConverter;
import org.jhotdraw8.css.parser.CssToken;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jspecify.annotations.Nullable;

public class StringCssConverter
extends AbstractCssConverter<String> {
    private final @Nullable String helpText;
    private final char quoteChar;
    private final String defaultValue;

    public StringCssConverter() {
        this(false, '\"', null);
    }

    public StringCssConverter(boolean nullable) {
        this(nullable, '\"', null);
    }

    public StringCssConverter(boolean nullable, char quoteChar, @Nullable String helpText) {
        super(nullable);
        this.quoteChar = quoteChar;
        this.helpText = helpText;
        this.defaultValue = "" + quoteChar + quoteChar;
    }

    @Override
    public @Nullable String getHelpText() {
        return this.helpText;
    }

    @Override
    public String parseNonNull(CssTokenizer tt, @Nullable IdResolver idResolver) throws ParseException, IOException {
        if (tt.next() != -4) {
            throw tt.createParseException("Could not convert \"" + String.valueOf(tt.getToken()) + "\" to a string value.");
        }
        return tt.currentStringNonNull();
    }

    @Override
    protected <TT extends String> void produceTokensNonNull(TT value, @Nullable IdSupplier idSupplier, Consumer<CssToken> out) {
        out.accept(new CssToken(-4, value, Character.valueOf(this.quoteChar)));
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }
}

