/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.css.converter;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.io.CharBufferReader;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jspecify.annotations.Nullable;

public class StringOrIdentCssConverter
implements Converter<String> {
    public @Nullable String fromString(CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        StreamCssTokenizer tt = new StreamCssTokenizer((Reader)new CharBufferReader(buf), null);
        try {
            if (tt.next() != -4 && tt.current() != -2) {
                throw new ParseException("Could not convert \"" + String.valueOf(tt.getToken()) + "\" to a string value.", buf.position());
            }
        }
        catch (IOException e) {
            ParseException parseException = new ParseException(e.getMessage(), 0);
            parseException.initCause(e);
            throw parseException;
        }
        return tt.currentString();
    }

    public void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable String value) throws IOException {
        if (value == null) {
            out.append("none");
            return;
        }
        StringBuilder buf = new StringBuilder();
        boolean isIdent = true;
        buf.append('\"');
        block5: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\"': {
                    buf.append('\\');
                    buf.append('\"');
                    isIdent = false;
                    continue block5;
                }
                case ' ': {
                    buf.append(ch);
                    isIdent = false;
                    continue block5;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('\n');
                    isIdent = false;
                    continue block5;
                }
                default: {
                    if (Character.isISOControl(ch) || Character.isWhitespace(ch)) {
                        buf.append('\\');
                        String hex = Integer.toHexString(ch);
                        int n = 6 - hex.length();
                        for (int i = 0; i < n; ++i) {
                            buf.append('0');
                        }
                        buf.append(hex);
                        continue block5;
                    }
                    buf.append(ch);
                }
            }
        }
        buf.append('\"');
        if (isIdent) {
            out.append(value);
        } else {
            out.append(buf.toString());
        }
    }

    public @Nullable String getDefaultValue() {
        return "";
    }
}

